-- ============================

-- Ce fichier a été créé à l'aide de l'utilitaire dblook de Derby.
-- Horodatage : 2018-07-04 10:48:26.789
-- La base de données source est : /Users/juliendescamps/Downloads/db
-- L'URL de connexion est : jdbc:derby:/Users/juliendescamps/Downloads/db;user=app;password=?
-- Le schéma spécifié est : app
-- appendLogs: false

-- ----------------------------------------------
-- Instructions DDL pour les tables
-- ----------------------------------------------

CREATE TABLE "APP"."BURIAL_PLOT" ("NAME" VARCHAR(100), "REFERENCE" VARCHAR(50), "CAPACITY" INTEGER, "SELL_DATE" TIMESTAMP, "DURATION" INTEGER, "COMMENTS" VARCHAR(5000), "LOCATION_ID" INTEGER NOT NULL, "BURIAL_PLOT_TYPE_ID" INTEGER NOT NULL, "ID" INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 550, INCREMENT BY 1), "CREATED_AT" TIMESTAMP NOT NULL, "UPDATED_AT" TIMESTAMP);

CREATE TABLE "APP"."BURIAL_PLOT_TYPE" ("LIB" VARCHAR(100) NOT NULL, "ID" INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1), "CREATED_AT" TIMESTAMP NOT NULL, "UPDATED_AT" TIMESTAMP);

CREATE TABLE "APP"."DATE_TYPE" ("LIB" VARCHAR(100) NOT NULL, "FORMAT" VARCHAR(50) NOT NULL, "ID" INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1), "CREATED_AT" TIMESTAMP NOT NULL, "UPDATED_AT" TIMESTAMP);

CREATE TABLE "APP"."DECEASED" ("FIRST_NAME" VARCHAR(100), "BIRTH_NAME" VARCHAR(100), "NICK_NAME" VARCHAR(50), "LAST_NAME" VARCHAR(100), "BIRTH_DATE" TIMESTAMP, "DEATH_DATE" TIMESTAMP, "BIRTH_DATE_TYPE_ID" INTEGER NOT NULL, "DEATH_DATE_TYPE_ID" INTEGER NOT NULL, "COMMENTS" VARCHAR(5000), "BURIAL_PLOT_ID" INTEGER NOT NULL, "DECEASED_TYPE_ID" INTEGER NOT NULL, "ID" INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 958, INCREMENT BY 1), "CREATED_AT" TIMESTAMP NOT NULL, "UPDATED_AT" TIMESTAMP);

CREATE TABLE "APP"."DECEASED_TYPE" ("LIB" VARCHAR(100) NOT NULL, "ID" INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1), "CREATED_AT" TIMESTAMP NOT NULL, "UPDATED_AT" TIMESTAMP);

CREATE TABLE "APP"."LOCATION" ("DXF_HANDLE" VARCHAR(16) NOT NULL, "REFERENCE" VARCHAR(50) NOT NULL, "COMMENTS" VARCHAR(5000), "LOCATION_TYPE_ID" INTEGER NOT NULL, "ID" INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 552, INCREMENT BY 1), "CREATED_AT" TIMESTAMP NOT NULL, "UPDATED_AT" TIMESTAMP);

CREATE TABLE "APP"."LOCATION_TYPE" ("LIB" VARCHAR(100) NOT NULL, "ID" INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1), "CREATED_AT" TIMESTAMP NOT NULL, "UPDATED_AT" TIMESTAMP);

CREATE TABLE "APP"."CHANGELOG" ("VERSION" INTEGER, "COMMENTS" VARCHAR(200), "ID" INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1), "CREATED_AT" TIMESTAMP NOT NULL, "UPDATED_AT" TIMESTAMP);

-- ----------------------------------------------
-- Instructions DDL pour les clés
-- ----------------------------------------------

-- PRIMARY/UNIQUE
ALTER TABLE "APP"."LOCATION_TYPE" ADD CONSTRAINT "SQL180703180852320" PRIMARY KEY ("ID");

ALTER TABLE "APP"."DECEASED_TYPE" ADD CONSTRAINT "SQL180703180852350" PRIMARY KEY ("ID");

ALTER TABLE "APP"."DECEASED" ADD CONSTRAINT "SQL180703180852780" PRIMARY KEY ("ID");

ALTER TABLE "APP"."BURIAL_PLOT" ADD CONSTRAINT "SQL180703180852740" UNIQUE ("REFERENCE");

ALTER TABLE "APP"."BURIAL_PLOT" ADD CONSTRAINT "SQL180703180852741" PRIMARY KEY ("ID");

ALTER TABLE "APP"."LOCATION" ADD CONSTRAINT "SQL180703180852700" UNIQUE ("REFERENCE");

ALTER TABLE "APP"."LOCATION" ADD CONSTRAINT "SQL180703180852701" PRIMARY KEY ("ID");

ALTER TABLE "APP"."CHANGELOG" ADD CONSTRAINT "SQL180703180852250" PRIMARY KEY ("ID");

ALTER TABLE "APP"."BURIAL_PLOT_TYPE" ADD CONSTRAINT "SQL180703180852330" PRIMARY KEY ("ID");

ALTER TABLE "APP"."DATE_TYPE" ADD CONSTRAINT "SQL180703180852640" PRIMARY KEY ("ID");

-- FOREIGN
ALTER TABLE "APP"."DECEASED" ADD CONSTRAINT "FK_BIRTH_DATE_TYPE_ID" FOREIGN KEY ("BIRTH_DATE_TYPE_ID") REFERENCES "APP"."DATE_TYPE" ("ID") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "APP"."DECEASED" ADD CONSTRAINT "FK_DEATH_DATE_TYPE_ID" FOREIGN KEY ("DEATH_DATE_TYPE_ID") REFERENCES "APP"."DATE_TYPE" ("ID") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "APP"."DECEASED" ADD CONSTRAINT "FK_BURIAL_PLOT_ID" FOREIGN KEY ("BURIAL_PLOT_ID") REFERENCES "APP"."BURIAL_PLOT" ("ID") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "APP"."DECEASED" ADD CONSTRAINT "FK_DECEASED_TYPE_ID" FOREIGN KEY ("DECEASED_TYPE_ID") REFERENCES "APP"."DECEASED_TYPE" ("ID") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "APP"."BURIAL_PLOT" ADD CONSTRAINT "FK_LOCATION_ID" FOREIGN KEY ("LOCATION_ID") REFERENCES "APP"."LOCATION" ("ID") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "APP"."BURIAL_PLOT" ADD CONSTRAINT "FK_BURIAL_PLOT_TYPE_ID" FOREIGN KEY ("BURIAL_PLOT_TYPE_ID") REFERENCES "APP"."BURIAL_PLOT_TYPE" ("ID") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "APP"."LOCATION" ADD CONSTRAINT "LOCATION_TYPE_ID" FOREIGN KEY ("LOCATION_TYPE_ID") REFERENCES "APP"."LOCATION_TYPE" ("ID") ON DELETE NO ACTION ON UPDATE NO ACTION;

-- ----------------------------------------------
-- Data
-- ----------------------------------------------

INSERT INTO APP.LOCATION_TYPE (LIB) VALUES
('Concession classique'),
('Colombarium'),
('Enfeu'),
('Ossuaire'),
('Fosse commune');

INSERT INTO APP.BURIAL_PLOT_TYPE (LIB) VALUES
('Sépulture provisoire'),
('Sépulture en pleine terre'),
('Tombe'),
('Caveautin'),
('Caveau à ciel ouvert'),
('Caveau avec toiture'),
('Enclos familial'),
('Enfeu'),
('Cavurne'), 
('Colombarium individuel');


INSERT INTO APP.DECEASED_TYPE (LIB) VALUES
('Cercueil'),
('Cercueil en zinc'), 
('Urne');


INSERT INTO APP.DATE_TYPE (LIB, FORMAT) VALUES
('Complet', 'dd/MM/yyyy'),
('Mois/Année', 'MM/yyyy'), 
('Année', 'yyyy');