/*
 * Decompiled with CFR 0.152.
 */
package scripts;

import context.Context;
import dao.DaoFactory;
import gui.exceptions.ContextException;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBCreator {
    public static final Log LOGGER = LogFactory.getLog(DBCreator.class);

    public static void main(String[] args) {
        DaoFactory daoFactory = null;
        try {
            Context context = new Context();
            daoFactory = context.getDaoFactory();
            daoFactory.createDatabase();
            daoFactory.beginConnectionScope();
            daoFactory.beforeCreateTables();
            daoFactory.createTables();
        }
        catch (ContextException | SQLException ex) {
            LOGGER.error((Object)ex);
        }
        finally {
            try {
                if (daoFactory != null) {
                    daoFactory.endConnectionScope();
                }
            }
            catch (IOException ex) {
                LOGGER.error((Object)ex);
            }
        }
    }
}

