/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import beans.model.AbstractModel;
import beans.model.Location;
import context.Context;
import dao.exceptions.SQLRuntimeException;
import gui.tree.DataCellRenderer;
import gui.tree.DataModel;
import gui.tree.IDataTree;
import java.sql.SQLException;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public final class DataTree
extends JTree
implements IDataTree {
    public DataTree(Context context) {
        this.getSelectionModel().setSelectionMode(1);
        this.setLargeModel(true);
        this.setFont(this.getFont().deriveFont((float)this.getFont().getSize() + 1.0f));
        this.setCellRenderer(new DataCellRenderer(context));
        try {
            this.setModel(new DataModel(context));
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    @Override
    public DataModel getDataModel() {
        return (DataModel)this.getModel();
    }

    @Override
    public void selectBy(final AbstractModel model, final Class<? extends AbstractModel> clazz) {
        this.browseAll(new TreePath(this.getModel().getRoot()), new BrowseCallBack(){

            private boolean test(Object node) {
                if (node.getClass().equals(clazz)) {
                    return ((AbstractModel)node).getId().equals(model.getId());
                }
                return false;
            }

            @Override
            public void execute(TreePath parent, Object node) {
                if (this.test(node)) {
                    DataTree.this.setSelectionPath(parent);
                    DataTree.this.expandPath(parent);
                    DataTree.this.scrollPathToVisible(parent);
                }
            }
        });
    }

    @Override
    public void selectBy(final String handle) {
        TreePath rootPath = new TreePath(this.getModel().getRoot());
        this.setSelectionPath(rootPath);
        this.browseAll(rootPath, new BrowseCallBack(){

            private boolean test(Object node) {
                if (node.getClass().equals(Location.class)) {
                    return ((Location)node).getDxfHandle().equals(handle);
                }
                return false;
            }

            @Override
            public void execute(TreePath parent, Object node) {
                if (this.test(node)) {
                    DataTree.this.setSelectionPath(parent);
                    DataTree.this.expandPath(parent);
                    DataTree.this.scrollPathToVisible(parent);
                }
            }
        });
    }

    @Override
    public void expandAll() {
        this.browseAll(new TreePath(this.getModel().getRoot()), (parent, node) -> this.expandPath(parent));
    }

    @Override
    public void collapseAll() {
        this.browseAll(new TreePath(this.getModel().getRoot()), (parent, node) -> {
            if (!this.getModel().getRoot().equals(node)) {
                this.collapsePath(parent);
            }
        });
    }

    private void browseAll(TreePath parent, BrowseCallBack callBack) {
        Object node = parent.getLastPathComponent();
        int l = this.getModel().getChildCount(node);
        for (int i = 0; i < l; ++i) {
            TreePath path = parent.pathByAddingChild(this.getModel().getChild(node, i));
            this.browseAll(path, callBack);
        }
        callBack.execute(parent, node);
    }

    private static interface BrowseCallBack {
        public void execute(TreePath var1, Object var2);
    }
}

