/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import beans.model.BurialPlot;
import beans.model.Cimetary;
import beans.model.DataNode;
import beans.model.Deceased;
import beans.model.Location;
import beans.model.NodeCache;
import beans.model.NodeCallback;
import beans.search.BurialPlotSO;
import beans.search.DeceasedSO;
import context.Context;
import dao.exceptions.SQLRuntimeException;
import dao.model.BurialPlotDao;
import dao.model.DeceasedDao;
import dao.model.LocationDao;
import gui.tree.IDataModel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public final class DataModel
implements TreeModel,
IDataModel {
    private final NodeCallback noFilterCallback = new NoFilterCallback();
    private final NodeCache nodeCache = new NodeCache(this.noFilterCallback);
    private final Cimetary cimetary = new Cimetary(new ArrayList<Location>());
    private final List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
    private final LocationDao locationDao;
    private final BurialPlotDao burialPlotDao;
    private final DeceasedDao deceasedDao;

    public DataModel(Context context) throws SQLException {
        this.locationDao = context.getDaoFactory().getLocationDAO();
        this.burialPlotDao = context.getDaoFactory().getBurialPlotDAO();
        this.deceasedDao = context.getDaoFactory().getDeceasedDAO();
    }

    @Override
    public Object getRoot() {
        return this.cimetary;
    }

    @Override
    public void findAll(String sort) throws SQLException {
        this.cimetary.setLocations(this.locationDao.findAll(sort));
        this.nodeCache.setNodeCallBack(this.noFilterCallback);
        this.reload();
    }

    @Override
    public void findBy(String handle) throws SQLException {
        this.cimetary.setLocations(this.locationDao.findBy(handle));
        this.nodeCache.setNodeCallBack(this.noFilterCallback);
        this.reload();
    }

    @Override
    public void findBy(Location location) throws SQLException {
        this.cimetary.setLocations(Arrays.asList((Location)this.locationDao.queryForId(location.getId())));
        this.nodeCache.setNodeCallBack(this.noFilterCallback);
        this.reload();
    }

    @Override
    public void findBy(BurialPlot burialPlot) throws SQLException {
        this.cimetary.setLocations(this.locationDao.findBy(burialPlot));
        this.nodeCache.setNodeCallBack(this.noFilterCallback);
        this.reload();
    }

    @Override
    public void findBy(Deceased deceased) throws SQLException {
        this.cimetary.setLocations(this.locationDao.findBy(deceased));
        this.nodeCache.setNodeCallBack(this.noFilterCallback);
        this.reload();
    }

    @Override
    public void findBy(final BurialPlotSO burialPlotSO, String sort) throws SQLException {
        this.cimetary.setLocations(this.locationDao.findBy(burialPlotSO, sort));
        this.nodeCache.setNodeCallBack(new NodeCallback(){

            @Override
            public List<BurialPlot> load(Location location) throws SQLException {
                return DataModel.this.burialPlotDao.findBy(location, burialPlotSO);
            }

            @Override
            public List<Deceased> load(BurialPlot burialPlot) throws SQLException {
                return DataModel.this.deceasedDao.findBy(burialPlot);
            }
        });
        this.reload();
    }

    @Override
    public void findBy(final DeceasedSO deceasedSO) throws SQLException {
        this.cimetary.setLocations(this.locationDao.findBy(deceasedSO));
        this.nodeCache.setNodeCallBack(new NodeCallback(){

            @Override
            public List<BurialPlot> load(Location location) throws SQLException {
                return DataModel.this.burialPlotDao.findBy(location, deceasedSO);
            }

            @Override
            public List<Deceased> load(BurialPlot burialPlot) throws SQLException {
                return DataModel.this.deceasedDao.findBy(burialPlot, deceasedSO);
            }
        });
        this.reload();
    }

    @Override
    public void search(final String text) throws SQLException {
        this.cimetary.setLocations(this.locationDao.search(text));
        this.nodeCache.setNodeCallBack(new NodeCallback(){

            @Override
            public List<BurialPlot> load(Location location) throws SQLException {
                return DataModel.this.burialPlotDao.search(location, text);
            }

            @Override
            public List<Deceased> load(BurialPlot burialPlot) throws SQLException {
                return DataModel.this.deceasedDao.search(burialPlot, text);
            }
        });
        this.reload();
    }

    @Override
    public Object getChild(Object parent, int index) {
        List list = null;
        try {
            list = ((DataNode)parent).getChildren(this.nodeCache);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
        return list != null ? list.get(index) : null;
    }

    @Override
    public int getChildCount(Object parent) {
        List list = null;
        try {
            list = ((DataNode)parent).getChildren(this.nodeCache);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
        return list != null ? list.size() : 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((DataNode)node).isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        List list = null;
        try {
            list = ((DataNode)parent).getChildren(this.nodeCache);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
        return list != null ? list.indexOf(child) : -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void reload() {
        this.nodeCache.clear();
        this.fireTreeStructureChanged(this.cimetary);
    }

    private void fireTreeStructureChanged(Cimetary root) {
        TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{root});
        for (TreeModelListener tml : this.listeners) {
            tml.treeStructureChanged(e);
        }
    }

    private static final class NoFilterCallback
    implements NodeCallback {
        private NoFilterCallback() {
        }

        @Override
        public List<BurialPlot> load(Location location) throws SQLException {
            return new ArrayList<BurialPlot>(location.getBurialPlots());
        }

        @Override
        public List<Deceased> load(BurialPlot burialPlot) throws SQLException {
            return new ArrayList<Deceased>(burialPlot.getDeceaseds());
        }
    }
}

