/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import beans.model.DataNode;
import context.Context;
import gui.components.JIcon;
import gui.components.factory.component.ComponentFactory;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public final class DataCellRenderer
extends DefaultTreeCellRenderer {
    private final String unknown;
    private final String root;
    private final ComponentFactory componentFactory;

    public DataCellRenderer(Context context) {
        this.componentFactory = context.getComponentFactory();
        this.unknown = context.getResourceBundle().getString("info.bean.unknown");
        this.root = context.getResourceBundle().getString("tree.root");
    }

    private String getDisplayName(DataNode node) {
        if (node.isUnknown()) {
            return this.unknown;
        }
        if (node.isRoot()) {
            return this.root;
        }
        return node.getDisplayName();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DataNode node = (DataNode)value;
        super.getTreeCellRendererComponent(tree, this.getDisplayName(node), sel, expanded, leaf, row, hasFocus);
        this.setIcon(this.componentFactory.imageIcon(new JIcon(node.getIconFileName())));
        tree.setRowHeight(this.getPreferredSize().height + 3);
        if (node.isUnknown() && !sel) {
            this.setForeground(Color.GRAY);
        }
        return this;
    }
}

