/*
 * Decompiled with CFR 0.152.
 */
package gui.panels;

import beans.model.BurialPlot;
import beans.model.DataNode;
import beans.model.Deceased;
import beans.model.Location;
import beans.search.BurialPlotSO;
import beans.search.DeceasedSO;
import context.Context;
import dao.exceptions.SQLRuntimeException;
import gui.components.JIcon;
import gui.components.JIconTextField;
import gui.components.factory.component.ComponentFactory;
import gui.dialogs.forms.beans.model.AbstractModelForm;
import gui.listeners.actions.TreePanelActions;
import gui.panels.AbstractPanel;
import gui.tree.DataTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public final class TreePanel
extends AbstractPanel {
    private final DataTree tree;
    private final String sort;
    private final JButton expandButton;
    private final JButton collapseButton;
    private final JButton centerButton;
    private final JButton resetButton;
    private final JPopupMenu popupMenu;
    private final JMenuItem createItem;
    private final JMenuItem updateItem;
    private final JIconTextField searchField;
    public static final Dimension DIMENSION = new Dimension(300, 300);
    public static final String PROP_SELECT_NODE = "selectNode";
    public static final String PROP_SELECT_LOCATION = "selectLocation";
    public static final String PROP_CENTER_BUTTON = "centerButton";
    public static final String PROP_RESET_BUTTON = "resetButton";
    private boolean fromMap = false;

    public TreePanel(Context context) {
        super(context);
        this.tree = new DataTree(context);
        this.sort = context.getConfiguration().getString("sorting", "alpha");
        ComponentFactory cf = this.getContext().getComponentFactory();
        this.searchField = cf.iconTextField(new JIcon("search.png"));
        this.expandButton = cf.button(new JIcon("arrow-270.png"));
        this.collapseButton = cf.button(new JIcon("arrow-090.png"));
        this.centerButton = cf.button(new JIcon("target.png"));
        this.resetButton = cf.button(new JIcon("reset.png"));
        this.popupMenu = cf.popupMenu("tree.menu.title");
        this.createItem = cf.menuItem("tree.menu.create", new JIcon("plus.png"));
        this.updateItem = cf.menuItem("tree.menu.update", new JIcon("pencil.png"));
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(DIMENSION);
        ComponentFactory cf = this.getContext().getComponentFactory();
        cf.setToolTipText(this.expandButton, "tree.tip.expand");
        cf.setToolTipText(this.collapseButton, "tree.tip.collapse");
        cf.setToolTipText(this.resetButton, "tree.tip.reset");
        ControlListener controlListener = new ControlListener();
        this.resetButton.addActionListener(controlListener);
        this.expandButton.addActionListener(controlListener);
        this.collapseButton.addActionListener(controlListener);
        this.centerButton.addActionListener(controlListener);
        this.searchField.addActionListener(new SearchListener());
        JPanel commandPanel = new JPanel(new GridLayout(1, 4));
        commandPanel.add(this.centerButton);
        commandPanel.add(this.expandButton);
        commandPanel.add(this.collapseButton);
        commandPanel.add(this.resetButton);
        this.add((Component)this.searchField, "First");
        this.add((Component)new JScrollPane(this.tree), "Center");
        this.add((Component)commandPanel, "Last");
        try {
            this.tree.getDataModel().findAll(this.sort);
            this.tree.addTreeSelectionListener(new DataSelectionListener());
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
        this.manageExpandButtons(false);
        this.centerButton.setEnabled(false);
        if (this.getContext().getSubject().isPermitted("update")) {
            MenuListener menuListener = new MenuListener();
            this.createItem.addActionListener(menuListener);
            this.updateItem.addActionListener(menuListener);
            this.popupMenu.add(this.createItem);
            this.popupMenu.add(this.updateItem);
            this.tree.addMouseListener(new RightClickListener(menuListener));
        }
    }

    public void resetTree() throws SQLException {
        this.tree.getDataModel().findAll(this.sort);
        this.searchField.setText("");
        this.manageExpandButtons(false);
        this.firePropertyChange(PROP_RESET_BUTTON, null, (Object)true);
    }

    public void findBy(String handle) throws SQLException {
        this.tree.getDataModel().findBy(handle);
        this.tree.expandAll();
        this.tree.selectBy(handle);
        this.searchField.setText("");
        this.manageExpandButtons(true);
    }

    public void findBy(Location location) throws SQLException {
        this.tree.getDataModel().findBy(location);
        this.tree.expandAll();
        this.tree.selectBy(location, Location.class);
        this.searchField.setText("");
        this.manageExpandButtons(true);
    }

    public void findBy(BurialPlot burialPlot) throws SQLException {
        this.tree.getDataModel().findBy(burialPlot);
        this.tree.expandAll();
        this.tree.selectBy(burialPlot, BurialPlot.class);
        this.searchField.setText("");
        this.manageExpandButtons(true);
    }

    public void findBy(Deceased deceased) throws SQLException {
        this.tree.getDataModel().findBy(deceased);
        this.tree.expandAll();
        this.tree.selectBy(deceased, Deceased.class);
        this.searchField.setText("");
        this.manageExpandButtons(true);
    }

    public void findBy(BurialPlotSO burialPlotSO) throws SQLException {
        this.tree.getDataModel().findBy(burialPlotSO, this.sort);
        this.tree.expandAll();
        this.searchField.setText("");
        this.manageExpandButtons(true);
    }

    public void findBy(DeceasedSO deceasedSO) throws SQLException {
        this.tree.getDataModel().findBy(deceasedSO);
        this.tree.expandAll();
        this.searchField.setText("");
        this.manageExpandButtons(true);
    }

    private void manageExpandButtons(boolean expanded) {
        this.expandButton.setEnabled(!expanded);
        this.collapseButton.setEnabled(expanded);
    }

    private void waitCursor() {
        Cursor waitCursor = Cursor.getPredefinedCursor(3);
        this.setCursor(waitCursor);
        this.searchField.setCursor(waitCursor);
    }

    private void resetCursor() {
        this.setCursor(null);
        this.searchField.setCursor(Cursor.getPredefinedCursor(2));
    }

    public void setFromMap(boolean fromMap) {
        this.fromMap = fromMap;
    }

    private final class DataSelectionListener
    implements TreeSelectionListener {
        private DataSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DataNode node = (DataNode)TreePanel.this.tree.getLastSelectedPathComponent();
            Location location = null;
            if (node == null) {
                this.resetButtons();
            } else {
                this.updateButtons(node);
                location = node.getLocationNode(e.getPath());
            }
            TreePanel.this.firePropertyChange(TreePanel.PROP_SELECT_NODE, null, node);
            if (!TreePanel.this.fromMap) {
                TreePanel.this.firePropertyChange(TreePanel.PROP_SELECT_LOCATION, null, location);
            }
        }

        private void updateButtons(DataNode node) {
            TreePanel.this.centerButton.setEnabled(node.getCenterStatus(TreePanel.this.getContext().getSubject()));
            TreePanel.this.centerButton.setToolTipText(node.getCenterLabel(TreePanel.this.getContext().getResourceBundle()));
        }

        private void resetButtons() {
            TreePanel.this.centerButton.setEnabled(false);
            TreePanel.this.centerButton.setToolTipText("");
        }
    }

    private final class MenuListener
    implements ActionListener {
        private DataNode dataNode;

        private MenuListener() {
        }

        public void setDataNode(DataNode dataNode) {
            this.dataNode = dataNode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem source = (JMenuItem)e.getSource();
            AbstractModelForm form = null;
            try {
                if (source.equals(TreePanel.this.createItem)) {
                    form = this.dataNode.getCreateForm(TreePanel.this.getContext());
                } else if (source.equals(TreePanel.this.updateItem)) {
                    form = this.dataNode.getUpdateForm(TreePanel.this.getContext());
                }
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
            if (form != null) {
                form.addPropertyChangeListener(new TreePanelActions(TreePanel.this));
                form.setVisible(true);
            }
        }
    }

    private final class SearchListener
    implements ActionListener {
        private SearchListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String text = TreePanel.this.searchField.getText().trim();
            TreePanel.this.waitCursor();
            try {
                if (!text.equals("")) {
                    TreePanel.this.tree.getDataModel().search(text);
                    TreePanel.this.tree.expandAll();
                    TreePanel.this.manageExpandButtons(true);
                }
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
            TreePanel.this.resetCursor();
        }
    }

    private final class ControlListener
    implements ActionListener {
        private ControlListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton source = (JButton)e.getSource();
            TreePanel.this.waitCursor();
            if (source.equals(TreePanel.this.expandButton)) {
                TreePanel.this.tree.expandAll();
                TreePanel.this.manageExpandButtons(true);
            } else if (source.equals(TreePanel.this.collapseButton)) {
                TreePanel.this.tree.collapseAll();
                TreePanel.this.manageExpandButtons(false);
            } else if (source.equals(TreePanel.this.resetButton)) {
                try {
                    TreePanel.this.resetTree();
                }
                catch (SQLException ex) {
                    throw new SQLRuntimeException(ex);
                }
            } else if (source.equals(TreePanel.this.centerButton)) {
                TreePanel.this.firePropertyChange(TreePanel.PROP_CENTER_BUTTON, null, true);
            }
            TreePanel.this.resetCursor();
        }
    }

    private final class RightClickListener
    extends MouseAdapter {
        private final MenuListener menuListener;

        public RightClickListener(MenuListener menuListener) {
            this.menuListener = menuListener;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() && SwingUtilities.isRightMouseButton(e)) {
                int row = TreePanel.this.tree.getRowForLocation(e.getX(), e.getY());
                TreePath path = TreePanel.this.tree.getPathForLocation(e.getX(), e.getY());
                if (row != -1) {
                    DataNode node = (DataNode)path.getLastPathComponent();
                    TreePanel.this.createItem.setVisible(node.getCreateStatus(TreePanel.this.getContext().getSubject()));
                    TreePanel.this.updateItem.setVisible(node.getUpdateStatus(TreePanel.this.getContext().getSubject()));
                    this.menuListener.setDataNode(node);
                    TreePanel.this.popupMenu.show((JComponent)e.getSource(), e.getX(), e.getY());
                }
            }
        }
    }
}

