/*
 * Decompiled with CFR 0.152.
 */
package gui.panels;

import beans.search.BurialPlotSO;
import context.Context;
import dao.DaoFactory;
import dao.exceptions.SQLRuntimeException;
import gui.components.JIconBig;
import gui.components.factory.component.ComponentFactory;
import gui.dialogs.menu.AdvSearchDialog;
import gui.dialogs.menu.TodaySearchDialog;
import gui.handlers.ColorHandler;
import gui.handlers.InvertedColorHandler;
import gui.listeners.actions.TreePanelActions;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public final class ToolBar
extends JToolBar {
    private final JButton zoomIn;
    private final JButton zoomOut;
    private final JButton zoomReset;
    private final JButton rotateLeft;
    private final JButton rotateRight;
    private final JToggleButton color;
    private final JButton searchForm;
    private final JButton searchToday;
    private final JButton print;
    private final JToggleButton pageFormat;
    private final Context context;
    private final ComponentFactory componentFactory;
    private final DaoFactory daoFactory;
    public static final ColorHandler COLOR_HANDLER = new ColorHandler();
    public static final ColorHandler INV_COLOR_HANDLER = new InvertedColorHandler();
    public static final String PROP_ZOOM_IN = "zoomIn";
    public static final String PROP_ZOOM_OUT = "zoomOut";
    public static final String PROP_ZOOM_RESET = "zoomFit";
    public static final String PROP_ROTATE_LEFT = "rotateLeft";
    public static final String PROP_ROTATE_RIGHT = "rotateRight";
    public static final String PROP_SWITCH_COLOR = "switchColor";
    public static final String PROP_SEARCH_TODAY = "searchToday";
    public static final String PROP_PRINT = "print";
    public static final String PROP_DISPLAY_PAGE_FORMAT = "displayPageFormat";

    public ToolBar(Context context) {
        super(1);
        this.context = context;
        this.componentFactory = context.getComponentFactory();
        this.daoFactory = context.getDaoFactory();
        this.zoomIn = this.componentFactory.button(new JIconBig("zoom-in.png"));
        this.zoomOut = this.componentFactory.button(new JIconBig("zoom-out.png"));
        this.zoomReset = this.componentFactory.button(new JIconBig("zoom-fit.png"));
        this.rotateLeft = this.componentFactory.button(new JIconBig("arrow-circle-left.png"));
        this.rotateRight = this.componentFactory.button(new JIconBig("arrow-circle-right.png"));
        this.searchForm = this.componentFactory.button(new JIconBig("adv-search.png"));
        this.searchToday = this.componentFactory.button(new JIconBig("clock.png"));
        this.print = this.componentFactory.button(new JIconBig("print.png"));
        this.pageFormat = this.componentFactory.toggleButton(new JIconBig("zone.png"));
        this.color = this.componentFactory.toggleButton(new JIconBig("switch.png"));
        this.initComponents();
    }

    private void initComponents() {
        this.add(this.zoomOut);
        this.add(this.zoomIn);
        this.add(this.zoomReset);
        this.addSeparator();
        this.add(this.rotateLeft);
        this.add(this.rotateRight);
        this.addSeparator();
        this.add(this.color);
        this.addSeparator();
        this.add(this.searchForm);
        this.add(this.searchToday);
        this.addSeparator();
        this.add(this.print);
        this.add(this.pageFormat);
        this.componentFactory.setToolTipText(this.zoomReset, "toolbar.tip.zoom_reset");
        this.componentFactory.setToolTipText(this.zoomIn, "toolbar.tip.zoom_in");
        this.componentFactory.setToolTipText(this.zoomOut, "toolbar.tip.zoom_out");
        this.componentFactory.setToolTipText(this.rotateLeft, "toolbar.tip.rotate_left");
        this.componentFactory.setToolTipText(this.rotateRight, "toolbar.tip.rotate_right");
        this.componentFactory.setToolTipText(this.color, "toolbar.tip.switch_color");
        this.componentFactory.setToolTipText(this.searchForm, "toolbar.tip.search_form");
        this.componentFactory.setToolTipText(this.searchToday, "toolbar.tip.search_today");
        this.componentFactory.setToolTipText(this.print, "toolbar.tip.print");
        this.componentFactory.setToolTipText(this.pageFormat, "toolbar.tip.page_format");
        this.setFloatable(false);
        ZoomListener zoomListener = new ZoomListener();
        RotateListener rotateListener = new RotateListener();
        this.zoomIn.addActionListener(zoomListener);
        this.zoomOut.addActionListener(zoomListener);
        this.zoomReset.addActionListener(zoomListener);
        this.rotateLeft.addActionListener(rotateListener);
        this.rotateRight.addActionListener(rotateListener);
        this.color.addActionListener(new ColorListener());
        this.searchForm.addActionListener(new AdvSearchListener());
        this.searchToday.addActionListener(new TodaySearchListener());
        this.print.addActionListener(new PrintListener());
        this.pageFormat.addActionListener(new DisplayPageFormatListener());
    }

    public static ColorHandler getColorHandler(boolean selected) {
        return selected ? COLOR_HANDLER : INV_COLOR_HANDLER;
    }

    private class PrintListener
    implements ActionListener {
        private PrintListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolBar.this.firePropertyChange(ToolBar.PROP_PRINT, null, true);
        }
    }

    private class DisplayPageFormatListener
    implements ActionListener {
        private DisplayPageFormatListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractButton abstractButton = (AbstractButton)e.getSource();
            boolean selected = abstractButton.getModel().isSelected();
            ToolBar.this.firePropertyChange(ToolBar.PROP_DISPLAY_PAGE_FORMAT, null, selected);
        }
    }

    private class TodaySearchListener
    implements ActionListener {
        private TodaySearchListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                BurialPlotSO so = new BurialPlotSO();
                so.setWithEndDate(true);
                so.setEndDateStart(null);
                so.setEndDateEnd(new Date());
                int count = (int)ToolBar.this.daoFactory.getBurialPlotDAO().countBy(so);
                int n = new TodaySearchDialog(ToolBar.this.context, count).show();
                if (count > 0 && n == 0) {
                    ToolBar.this.firePropertyChange(ToolBar.PROP_SEARCH_TODAY, null, so);
                }
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
        }
    }

    private class AdvSearchListener
    implements ActionListener {
        private AdvSearchListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdvSearchDialog dialog = new AdvSearchDialog(ToolBar.this.context);
            for (PropertyChangeListener listener : ToolBar.this.getPropertyChangeListeners()) {
                if (!(listener instanceof TreePanelActions)) continue;
                dialog.addAllPropertyChangeListener(listener);
            }
            dialog.setVisible(true);
        }
    }

    private class ColorListener
    implements ActionListener {
        private ColorListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractButton abstractButton = (AbstractButton)e.getSource();
            boolean selected = abstractButton.getModel().isSelected();
            ToolBar.this.firePropertyChange(ToolBar.PROP_SWITCH_COLOR, null, selected);
        }
    }

    private class RotateListener
    implements ActionListener {
        private RotateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton source = (JButton)e.getSource();
            if (source.equals(ToolBar.this.rotateLeft)) {
                ToolBar.this.firePropertyChange(ToolBar.PROP_ROTATE_LEFT, null, true);
            } else if (source.equals(ToolBar.this.rotateRight)) {
                ToolBar.this.firePropertyChange(ToolBar.PROP_ROTATE_RIGHT, null, true);
            }
        }
    }

    private class ZoomListener
    implements ActionListener {
        private ZoomListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton source = (JButton)e.getSource();
            if (source.equals(ToolBar.this.zoomIn)) {
                ToolBar.this.firePropertyChange(ToolBar.PROP_ZOOM_IN, null, true);
            } else if (source.equals(ToolBar.this.zoomOut)) {
                ToolBar.this.firePropertyChange(ToolBar.PROP_ZOOM_OUT, null, true);
            } else if (source.equals(ToolBar.this.zoomReset)) {
                ToolBar.this.firePropertyChange(ToolBar.PROP_ZOOM_RESET, null, true);
            }
        }
    }
}

