/*
 * Decompiled with CFR 0.152.
 */
package gui.panels;

import context.Context;
import geom.AbstractShape;
import gui.components.factory.component.ComponentFactory;
import gui.panels.AbstractPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public final class StatusPanel
extends AbstractPanel {
    private final JPanel textPanel = new JPanel();
    private final JLabel positionLabel = new JLabel("x: 0,00 - y: 0,00");
    private final JLabel infosLabel = new JLabel();
    private final JLabel loginLabel;

    public StatusPanel(Context context) {
        super(context);
        ComponentFactory cf = this.getContext().getComponentFactory();
        this.loginLabel = cf.label("login.no_status");
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setLogin(this.getContext().getSubject().getPrincipal().toString());
        this.infosLabel.setHorizontalAlignment(0);
        this.positionLabel.setPreferredSize(new Dimension(200, 10));
        this.textPanel.setLayout(new BorderLayout());
        this.textPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.textPanel.add((Component)this.positionLabel, "Before");
        if (this.getContext().getSubject().isPermitted("administrate")) {
            this.textPanel.add((Component)this.infosLabel, "Center");
        }
        this.textPanel.add((Component)this.loginLabel, "After");
        this.add((Component)new JSeparator(0), "First");
        this.add((Component)this.textPanel, "Center");
    }

    public void setInfos(AbstractShape shape) {
        String format = String.format("DXF Handle : %s - Position x: %.2f y: %.2f", shape.getHandle(), shape.getPosition().getX(), shape.getPosition().getY());
        this.infosLabel.setText(format);
    }

    public void noInfos() {
        this.infosLabel.setText(null);
    }

    public void setLogin(String login) {
        String status = this.getContext().getResourceBundle().getString("login.status");
        this.loginLabel.setText(String.format("%s [%s]", status, login));
    }

    public void setPosition(Point2D point) {
        this.positionLabel.setText(String.format("x: %.2f - y: %.2f", point.getX(), point.getY()));
    }
}

