/*
 * Decompiled with CFR 0.152.
 */
package gui.panels;

import context.Context;
import geom.AbstractShape;
import geom.CompositeShape;
import geom.ShapeVisitor;
import geom.entities.Entity;
import geom.entities.Layer;
import geom.entities.shapes.Paragraph;
import gui.handlers.ColorHandler;
import gui.handlers.DocumentHandler;
import gui.handlers.TransformHandler;
import gui.panels.AbstractPanel;
import gui.panels.ToolBar;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import org.apache.commons.configuration.Configuration;

public final class MapPanel
extends AbstractPanel
implements Printable {
    private final TransformHandler transformHandler;
    private final CompositeShape layers;
    private final BasicStroke stroke;
    private final BasicStroke hoverStroke;
    private final boolean antiAliasing;
    private final boolean hoverEffect;
    private ColorHandler colorHandler = ToolBar.getColorHandler(false);
    private boolean displayPageFormat = false;
    private PageFormat pageFormat = MapPanel.getDefaultPageFormat();
    private AbstractShape selectedShape;
    private AbstractShape hoveredShape;
    private static final float[] DASH_STYLE = new float[]{10.0f};
    private static final BasicStroke DASHED = new BasicStroke(1.0f, 0, 0, 10.0f, DASH_STYLE, 0.0f);
    public static final Font FONT = new Font("Monospaced", 0, 12);
    public static final Dimension DIMENSION = new Dimension(700, 500);
    public static final float DEFAUT_STROKE = 0.05f;
    public static final float DEFAUT_HOVER_STROKE = 3.0f;
    public static final boolean DEFAUT_ANTIALIASING = false;
    public static final boolean DEFAUT_HOVER_EFFECT = false;
    public static final String PROP_CURSOR_POSITION = "cursorPosition";
    public static final String PROP_SELECT_SHAPE = "selectedShape";
    public static final String PROP_INFOS_SHAPE = "infosShape";

    public MapPanel(Context context, DocumentHandler documentHandler) {
        super(context);
        Configuration config = context.getConfiguration();
        this.layers = documentHandler.getLayers();
        this.transformHandler = documentHandler.createTransformHandler();
        this.stroke = new BasicStroke(config.getFloat("stroke_width", 0.05f));
        this.hoverStroke = new BasicStroke(config.getFloat("hover_stroke_width", 3.0f));
        this.antiAliasing = config.getBoolean("antialiasing", false);
        this.hoverEffect = config.getBoolean("hover_effect", false);
        this.initComponents();
    }

    private void initComponents() {
        this.setPreferredSize(DIMENSION);
        this.setDoubleBuffered(true);
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.setBackground(this.colorHandler.getBackgroundColor());
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.addMouseWheelListener(mouseHandler);
        ComponentHandler cmpHandler = new ComponentHandler();
        this.addComponentListener(cmpHandler);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setFont(FONT);
        this.setRenderingHints(g2d);
        this.drawBackground(this.getSize(), g2d);
        if (this.displayPageFormat) {
            this.drawPageFormat(g2d);
        }
        g2d.transform(this.transformHandler.getTransform());
        g2d.setStroke(this.stroke);
        this.layers.draw(g2d);
    }

    private void setRenderingHints(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antiAliasing ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
    }

    public void setColorHandler(final ColorHandler colorHandler) {
        this.colorHandler = colorHandler;
        this.layers.accept(new ShapeVisitor(){

            @Override
            public void visit(Entity entity) {
                entity.setColorHandler(colorHandler);
                entity.initColor();
            }

            @Override
            public void visit(Paragraph paragraph) {
                paragraph.setColorHandler(colorHandler);
                paragraph.initColor();
            }

            @Override
            public void visit(Layer layer) {
                layer.setColorHandler(colorHandler);
                layer.initColor();
            }
        });
    }

    public static PageFormat getDefaultPageFormat() {
        PageFormat pf = PrinterJob.getPrinterJob().defaultPage();
        pf.setOrientation(0);
        return pf;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    private static Rectangle2D toRectangle2D(PageFormat pf) {
        return new Rectangle2D.Double(pf.getImageableX(), pf.getImageableY(), pf.getImageableWidth(), pf.getImageableHeight());
    }

    private void drawPageFormat(Graphics2D g2d) {
        Stroke oldStroke = g2d.getStroke();
        Color oldColor = g2d.getColor();
        g2d.setStroke(DASHED);
        g2d.setColor(Color.GRAY);
        g2d.draw(MapPanel.toRectangle2D(this.pageFormat));
        g2d.setColor(oldColor);
        g2d.setStroke(oldStroke);
    }

    public void displayPageFormat(boolean displayPageFormat) {
        this.displayPageFormat = displayPageFormat;
    }

    private void drawBackground(Dimension2D d, Graphics2D g2d) {
        this.drawBackground(new Rectangle2D.Double(0.0, 0.0, d.getWidth(), d.getHeight()), g2d);
    }

    private void drawBackground(Rectangle2D r, Graphics2D g2d) {
        Color oldColor = g2d.getColor();
        g2d.setColor(this.colorHandler.getBackgroundColor());
        g2d.fill(r);
        g2d.setColor(oldColor);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setFont(FONT);
        this.setRenderingHints(g2d);
        this.drawBackground(MapPanel.toRectangle2D(this.pageFormat), g2d);
        g2d.transform(this.transformHandler.getTransform());
        g2d.setStroke(this.stroke);
        this.layers.draw(g2d);
        return 0;
    }

    public void zoomIn() throws NoninvertibleTransformException {
        this.transformHandler.zoomIn();
    }

    public void zoomOut() throws NoninvertibleTransformException {
        this.transformHandler.zoomOut();
    }

    public void rotateLeft() throws NoninvertibleTransformException {
        this.transformHandler.rotateLeft();
    }

    public void rotateRight() throws NoninvertibleTransformException {
        this.transformHandler.rotateRight();
    }

    public void reset() {
        this.transformHandler.init();
    }

    public void center(Point2D p) throws NoninvertibleTransformException {
        this.transformHandler.center(p);
    }

    private boolean hoverShape(Point2D p) {
        AbstractShape shape = this.layers.match(p);
        if (shape == null) {
            if (this.hoveredShape == null) {
                return false;
            }
            this.hoveredShape.setStroke(null);
            this.hoveredShape = null;
            return true;
        }
        if (shape.equals(this.hoveredShape)) {
            return false;
        }
        if (this.hoveredShape != null) {
            this.hoveredShape.setStroke(null);
        }
        this.hoveredShape = shape;
        this.hoveredShape.setStroke(this.hoverStroke);
        return true;
    }

    private void selectShape(Point2D p) {
        if (this.selectedShape != null) {
            this.selectedShape.setFillColor(null);
        }
        this.selectedShape = this.layers.match(p);
        if (this.selectedShape != null) {
            this.selectedShape.setFillColor(this.colorHandler.getSelectedFillColor());
        }
        this.firePropertyChange(PROP_SELECT_SHAPE, null, this.selectedShape);
    }

    public void selectShape(String handle) {
        if (this.selectedShape != null) {
            this.selectedShape.setFillColor(null);
        }
        this.selectedShape = this.layers.match(handle);
        if (this.selectedShape != null) {
            this.selectedShape.setFillColor(this.colorHandler.getSelectedFillColor());
        }
        this.firePropertyChange(PROP_INFOS_SHAPE, null, this.selectedShape);
    }

    public void setSelectedShape(AbstractShape selectedShape) {
        this.selectedShape = selectedShape;
    }

    public AbstractShape getSelectedShape() {
        return this.selectedShape;
    }

    public ColorHandler getColorHandler() {
        return this.colorHandler;
    }

    private final class MouseHandler
    extends MouseAdapter {
        private final Point2D lastPoint = new Point2D.Double();

        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            try {
                Point2D p = MapPanel.this.transformHandler.inverseTransform(e.getPoint());
                this.lastPoint.setLocation(p);
            }
            catch (NoninvertibleTransformException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            MapPanel.this.setCursor(Cursor.getPredefinedCursor(1));
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            MapPanel.this.setCursor(Cursor.getPredefinedCursor(13));
            try {
                Point2D point = MapPanel.this.transformHandler.inverseTransform(e.getPoint());
                MapPanel.this.transformHandler.translate(point.getX() - this.lastPoint.getX(), point.getY() - this.lastPoint.getY());
                MapPanel.this.repaint();
            }
            catch (NoninvertibleTransformException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            try {
                if (e.getScrollType() == 0) {
                    if (e.getWheelRotation() > 0) {
                        MapPanel.this.transformHandler.zoomIn();
                    } else {
                        MapPanel.this.transformHandler.zoomOut();
                    }
                    MapPanel.this.repaint();
                }
            }
            catch (NoninvertibleTransformException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            try {
                Point2D p = MapPanel.this.transformHandler.inverseTransform(e.getPoint());
                if (MapPanel.this.hoverEffect && MapPanel.this.hoverShape(p)) {
                    MapPanel.this.repaint();
                }
                MapPanel.this.firePropertyChange(MapPanel.PROP_CURSOR_POSITION, null, p);
            }
            catch (NoninvertibleTransformException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            MapPanel.this.firePropertyChange(MapPanel.PROP_CURSOR_POSITION, null, new Point2D.Double());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                try {
                    Point2D p = MapPanel.this.transformHandler.inverseTransform(e.getPoint());
                    MapPanel.this.selectShape(p);
                    MapPanel.this.repaint();
                }
                catch (NoninvertibleTransformException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    private final class ComponentHandler
    extends ComponentAdapter {
        private boolean firstPaint = true;

        private ComponentHandler() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            MapPanel.this.repaint();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Dimension windowSize = MapPanel.this.getSize();
            if (!this.firstPaint) {
                try {
                    MapPanel.this.transformHandler.center(windowSize);
                }
                catch (NoninvertibleTransformException ex) {
                    throw new RuntimeException(ex);
                }
            }
            MapPanel.this.transformHandler.setPanelSize(windowSize);
            if (this.firstPaint) {
                MapPanel.this.transformHandler.init();
                this.firstPaint = false;
            }
            MapPanel.this.repaint();
        }
    }
}

