/*
 * Decompiled with CFR 0.152.
 */
package gui.panels;

import context.Context;
import geom.AbstractShape;
import geom.CompositeShape;
import geom.entities.Layer;
import gui.components.JIcon;
import gui.components.factory.component.ComponentFactory;
import gui.handlers.DocumentHandler;
import gui.panels.AbstractPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

public final class LayersPanel
extends AbstractPanel {
    private final JButton allButton;
    private final JButton resetButton;
    private final JButton noneButton;
    private final JTable layersTable = new JTable();
    private final JPanel controlPanel = new JPanel(new GridLayout(1, 2));
    private final JScrollPane scrollPane = new JScrollPane(this.layersTable);
    private final LayersTableModel layersTableModel;
    private final CompositeShape layers;
    public static final Dimension DIMENSION = new Dimension(200, 200);
    public static final String PROP_SELECT_LAYERS = "selectLayers";

    public LayersPanel(Context context, DocumentHandler documentHandler) {
        super(context);
        this.layers = documentHandler.getLayers();
        this.layersTableModel = new LayersTableModel(this.getContext().getResourceBundle(), this.layers);
        ComponentFactory cf = this.getContext().getComponentFactory();
        this.allButton = cf.button("layers.button.all", new JIcon("selection-select.png"));
        this.resetButton = cf.button("layers.button.reset", new JIcon("reset.png"));
        this.noneButton = cf.button("layers.button.none", new JIcon("selection.png"));
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.layersTableModel.addTableModelListener(new LayersTableModelListener());
        this.layersTable.setModel(this.layersTableModel);
        this.layersTable.setDefaultRenderer(Color.class, new ColorRenderer());
        this.layersTable.setFillsViewportHeight(true);
        TableColumnModel columnModel = this.layersTable.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(50);
        columnModel.getColumn(1).setPreferredWidth(190);
        columnModel.getColumn(2).setPreferredWidth(60);
        ControlListener controlListener = new ControlListener();
        this.allButton.addActionListener(controlListener);
        this.noneButton.addActionListener(controlListener);
        this.resetButton.addActionListener(controlListener);
        this.controlPanel.add(this.allButton);
        this.controlPanel.add(this.noneButton);
        this.controlPanel.add(this.resetButton);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.controlPanel, "Last");
        this.setPreferredSize(DIMENSION);
    }

    public void reload() {
        this.layersTableModel.reload();
    }

    private static final class ColorRenderer
    extends DefaultTableCellRenderer {
        public ColorRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground((Color)value);
            this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            return this;
        }
    }

    private static final class LayersTableModel
    extends AbstractTableModel {
        private final CompositeShape layers;
        private final String[] columnNames;

        public LayersTableModel(ResourceBundle resourceBundle, CompositeShape layers) {
            this.layers = layers;
            this.columnNames = new String[]{resourceBundle.getString("layers.column.active"), resourceBundle.getString("layers.column.name"), resourceBundle.getString("layers.column.color")};
        }

        public void reload() {
            this.fireTableDataChanged();
        }

        public void reset() {
            int row = 0;
            for (AbstractShape shape : this.layers) {
                Layer layer = (Layer)shape;
                layer.setVisible(layer.getDefaultVisibility());
                this.fireTableCellUpdated(row++, 0);
            }
        }

        public void selectAll() {
            int row = 0;
            for (AbstractShape layer : this.layers) {
                layer.setVisible(true);
                this.fireTableCellUpdated(row++, 0);
            }
        }

        public void selectNone() {
            int row = 0;
            for (AbstractShape layer : this.layers) {
                layer.setVisible(false);
                this.fireTableCellUpdated(row++, 0);
            }
        }

        @Override
        public int getRowCount() {
            return this.layers.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        private Object getValueAt(Layer layer, int columnIndex) {
            switch (columnIndex) {
                default: {
                    return layer.isVisible();
                }
                case 1: {
                    return layer.getName();
                }
                case 2: 
            }
            return layer.getColor();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.getValueAt((Layer)this.layers.get(rowIndex), columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                this.layers.get(rowIndex).setVisible((Boolean)aValue);
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnNames[columnIndex];
        }
    }

    private final class LayersTableModelListener
    implements TableModelListener {
        private LayersTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getColumn() == 0) {
                LayersPanel.this.firePropertyChange(LayersPanel.PROP_SELECT_LAYERS, false, true);
            }
        }
    }

    private final class ControlListener
    implements ActionListener {
        private ControlListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton source = (JButton)e.getSource();
            if (source.equals(LayersPanel.this.allButton)) {
                LayersPanel.this.layersTableModel.selectAll();
            } else if (source.equals(LayersPanel.this.noneButton)) {
                LayersPanel.this.layersTableModel.selectNone();
            } else if (source.equals(LayersPanel.this.resetButton)) {
                LayersPanel.this.layersTableModel.reset();
            }
        }
    }
}

