/*
 * Decompiled with CFR 0.152.
 */
package gui.panels;

import beans.model.BurialPlot;
import beans.model.DataNode;
import beans.model.DateType;
import beans.model.Deceased;
import beans.model.Location;
import context.Context;
import gui.panels.AbstractPanel;
import gui.utils.DateUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public final class InfoPanel
extends AbstractPanel {
    private final InfoTable table;
    private final JScrollPane tableScrollPane;
    private final JSplitPane splitPane;
    private final JTextArea commentsArea = new JTextArea();
    private final JScrollPane commentsScrollPane = new JScrollPane(this.commentsArea);
    public static final Dimension DIMENSION = new Dimension(300, 200);
    public static final String PROP_CLICK_LINK = "clickLink";

    public InfoPanel(Context context) {
        super(context);
        this.table = new InfoTable();
        this.tableScrollPane = new JScrollPane(this.table);
        this.splitPane = new JSplitPane(0, this.tableScrollPane, this.commentsScrollPane);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.commentsArea.setLineWrap(true);
        this.commentsArea.setWrapStyleWord(true);
        this.commentsArea.setEditable(false);
        this.splitPane.setResizeWeight(0.0);
        this.splitPane.setDividerSize(0);
        this.splitPane.setBackground(Color.red);
        this.splitPane.getBottomComponent().setVisible(false);
        this.add(this.splitPane);
        this.tableScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.commentsScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.setPreferredSize(DIMENSION);
    }

    private void manageComments(String comments) {
        if (comments == null) {
            this.splitPane.getBottomComponent().setVisible(false);
            this.splitPane.setDividerLocation(0);
        } else {
            this.splitPane.getBottomComponent().setVisible(true);
            this.splitPane.setDividerLocation(this.table.getPreferredSize().height);
            this.splitPane.setDividerSize(5);
            this.commentsArea.setText(comments);
            this.commentsArea.setCaretPosition(0);
        }
    }

    public void setData(Location location) throws SQLException {
        this.table.getInfoTableModel().setData(location);
        this.manageComments(location.getComments());
    }

    public void setData(BurialPlot burialPlot) throws SQLException {
        this.table.getInfoTableModel().setData(burialPlot);
        this.manageComments(burialPlot.getComments());
    }

    public void setData(Deceased deceased) throws SQLException {
        this.table.getInfoTableModel().setData(deceased);
        this.manageComments(deceased.getComments());
    }

    public void noData() {
        this.table.getInfoTableModel().noData();
        this.manageComments(null);
    }

    private static final class LinkRenderer
    extends DefaultTableCellRenderer {
        private final ResourceBundle resourceBundle;

        public LinkRenderer(ResourceBundle resourceBundle) {
            this.resourceBundle = resourceBundle;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            Link link = (Link)value;
            this.setForeground(link.getColor());
            if (link.toString() == null) {
                this.setText(this.resourceBundle.getString("info.bean.unknown"));
            } else {
                this.setText(link.toString());
            }
            return this;
        }
    }

    private static final class NullRenderer
    extends DefaultTableCellRenderer {
        private final ResourceBundle resourceBundle;

        public NullRenderer(ResourceBundle resourceBundle) {
            this.resourceBundle = resourceBundle;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            this.setForeground(new Color(180, 180, 180));
            this.setText(this.resourceBundle.getString("info.bean.unknown"));
            return this;
        }
    }

    private static final class DateTimeRenderer
    extends DefaultTableCellRenderer {
        private final DateUtils dateUtils = new DateUtils();

        private DateTimeRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            this.setText(this.dateUtils.formatDateTime((Date)value));
            return this;
        }
    }

    private static final class NoTimeDateRenderer
    extends DefaultTableCellRenderer {
        private final DateUtils dateUtils = new DateUtils();
        private final ResourceBundle resourceBundle;

        public NoTimeDateRenderer(ResourceBundle resourceBundle) {
            this.resourceBundle = resourceBundle;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            NoTimeDate date = (NoTimeDate)value;
            if (date.getDate() == null) {
                this.setForeground(new Color(180, 180, 180));
                this.setText(this.resourceBundle.getString("info.bean.unknown"));
            } else {
                this.setText(this.dateUtils.formatDate(date.getDate()));
            }
            return this;
        }
    }

    private static final class VarDateRenderer
    extends DefaultTableCellRenderer {
        private final DateUtils dateUtils = new DateUtils();
        private final ResourceBundle resourceBundle;

        public VarDateRenderer(ResourceBundle resourceBundle) {
            this.resourceBundle = resourceBundle;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            VarDate varDate = (VarDate)value;
            if (varDate.getDate() == null) {
                this.setForeground(new Color(180, 180, 180));
                this.setText(this.resourceBundle.getString("info.bean.unknown"));
            } else {
                this.setText(this.dateUtils.formatVarDate(varDate.getType(), varDate.getDate()));
            }
            return this;
        }
    }

    private static final class TitleRenderer
    extends DefaultTableCellRenderer {
        private final ResourceBundle resourceBundle;

        public TitleRenderer(ResourceBundle resourceBundle) {
            this.resourceBundle = resourceBundle;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            this.setText(this.resourceBundle.getString(value.toString()));
            return this;
        }
    }

    private static final class InfoTableModel
    extends AbstractTableModel {
        private final DataList data = new DataList();

        private InfoTableModel() {
        }

        public void noData() {
            this.data.clear();
            this.fireTableDataChanged();
        }

        public void setData(Location l) throws SQLException {
            this.data.clear();
            this.data.addTitle("info.object", "info.location.object");
            this.data.addObject("info.location.id", l.getId());
            this.data.addObject("info.location.type", l.getLocationType().getLib());
            this.data.addObject("info.location.dxf_handle", l.getDxfHandle());
            this.data.addObject("info.location.reference", l.getReference());
            this.data.addLinks("info.location.burialplots", l.getBurialPlots());
            this.data.addObject("info.created_at", l.getCreatedAt());
            this.data.addObject("info.updated_at", l.getUpdatedAt());
            this.fireTableDataChanged();
        }

        public void setData(BurialPlot bp) throws SQLException {
            this.data.clear();
            this.data.addTitle("info.object", "info.burialplot.object");
            this.data.addObject("info.burialplot.id", bp.getId());
            this.data.addObject("info.burialplot.name", bp.getName());
            this.data.addObject("info.burialplot.reference", bp.getReference());
            this.data.addObject("info.burialplot.type", bp.getBurialPlotType().getLib());
            this.data.addObject("info.burialplot.capacity", bp.getCapacity());
            this.data.addNoTimeDate("info.burialplot.sell_date", bp.getSellDate());
            this.data.addObject("info.burialplot.duration", bp.getDuration());
            this.data.addNoTimeDate("info.burialplot.end_date", bp.getEndDate());
            this.data.addLink("info.burialplot.location", bp.getLocation());
            this.data.addLinks("info.burialplot.deceased", bp.getDeceaseds());
            this.data.addObject("info.created_at", bp.getCreatedAt());
            this.data.addObject("info.updated_at", bp.getUpdatedAt());
            this.fireTableDataChanged();
        }

        public void setData(Deceased d) throws SQLException {
            this.data.clear();
            this.data.addTitle("info.object", "info.deceased.object");
            this.data.addObject("info.deceased.id", d.getId());
            this.data.addObject("info.deceased.last_name", d.getLastName());
            this.data.addObject("info.deceased.birth_name", d.getBirthName());
            this.data.addObject("info.deceased.first_name", d.getFirstName());
            this.data.addObject("info.deceased.nick_name", d.getNickName());
            this.data.addVarDate("info.deceased.birth_date", d.getBirthDateType(), d.getBirthDate());
            this.data.addVarDate("info.deceased.death_date", d.getDeathDateType(), d.getDeathDate());
            this.data.addObject("info.deceased.type", d.getDeceasedType().getLib());
            this.data.addLink("info.deceased.burialplot", d.getBurialPlot());
            this.data.addObject("info.created_at", d.getCreatedAt());
            this.data.addObject("info.updated_at", d.getUpdatedAt());
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data.get(rowIndex)[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return null;
        }
    }

    private final class InfoTable
    extends JTable {
        public InfoTable() {
            this.setModel(new InfoTableModel());
            this.setTableHeader(null);
            this.setRowSelectionAllowed(false);
            this.addMouseMotionListener(new MouseInputAdapter(){

                private Cursor getCursor(Point p) {
                    if (InfoTable.this.getValueAt(InfoTable.this.rowAtPoint(p), InfoTable.this.columnAtPoint(p)) instanceof Link) {
                        return Cursor.getPredefinedCursor(12);
                    }
                    return Cursor.getPredefinedCursor(0);
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    InfoPanel.this.setCursor(this.getCursor(e.getPoint()));
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Point p = e.getPoint();
                    Object o = InfoTable.this.getValueAt(InfoTable.this.rowAtPoint(p), InfoTable.this.columnAtPoint(p));
                    if (o instanceof Link) {
                        InfoPanel.this.firePropertyChange(InfoPanel.PROP_CLICK_LINK, null, ((Link)o).getNode());
                    }
                }
            });
        }

        public InfoTableModel getInfoTableModel() {
            return (InfoTableModel)this.getModel();
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            Object value = this.getValueAt(row, column);
            ResourceBundle bundle = InfoPanel.this.getContext().getResourceBundle();
            if (value == null) {
                return new NullRenderer(bundle);
            }
            if (value instanceof Date) {
                return new DateTimeRenderer();
            }
            if (value instanceof TableData) {
                return ((TableData)value).getRenderer(bundle);
            }
            return super.getCellRenderer(row, column);
        }
    }

    private static final class DataList
    extends AbstractList<Object[]> {
        private final List<Object[]> list = new ArrayList<Object[]>();

        private DataList() {
        }

        public void addTitle(String col1, String col2) {
            this.list.add(new Object[]{new Title(col1), new Title(col2)});
        }

        public void addLink(String col1, DataNode col2) {
            this.list.add(new Object[]{new Title(col1), new Link(col2)});
        }

        public void addNoTimeDate(String col, Date date) {
            this.list.add(new Object[]{new Title(col), new NoTimeDate(date)});
        }

        public void addVarDate(String col, DateType type, Date date) {
            this.list.add(new Object[]{new Title(col), new VarDate(type, date)});
        }

        public void addObject(String col1, Object col2) {
            this.list.add(new Object[]{new Title(col1), col2});
        }

        public <T extends DataNode> void addLinks(String col1, Collection<T> col2) {
            boolean first = true;
            for (DataNode e : col2) {
                if (first) {
                    this.list.add(new Object[]{new Title(col1), new Link(e)});
                    first = false;
                    continue;
                }
                this.list.add(new Object[]{"", new Link(e)});
            }
        }

        @Override
        public Object[] get(int index) {
            return this.list.get(index);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public Object[] remove(int index) {
            return this.list.remove(index);
        }
    }

    private static final class NoTimeDate
    implements TableData {
        private final Date date;

        public NoTimeDate(Date date) {
            this.date = date;
        }

        public Date getDate() {
            return this.date;
        }

        @Override
        public DefaultTableCellRenderer getRenderer(ResourceBundle bundle) {
            return new NoTimeDateRenderer(bundle);
        }
    }

    private static final class VarDate
    implements TableData {
        private final DateType type;
        private final Date date;

        public VarDate(DateType type, Date date) {
            this.type = type;
            this.date = date;
        }

        public Date getDate() {
            return this.date;
        }

        public DateType getType() {
            return this.type;
        }

        @Override
        public DefaultTableCellRenderer getRenderer(ResourceBundle bundle) {
            return new VarDateRenderer(bundle);
        }
    }

    private static final class Title
    implements TableData {
        private final String text;

        public Title(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        @Override
        public DefaultTableCellRenderer getRenderer(ResourceBundle bundle) {
            return new TitleRenderer(bundle);
        }
    }

    private static final class Link
    implements TableData {
        private final Color color = Color.BLUE;
        private final DataNode node;

        public Link(DataNode node) {
            this.node = node;
        }

        public Color getColor() {
            return this.color;
        }

        public DataNode getNode() {
            return this.node;
        }

        public String toString() {
            return this.node.getDisplayName();
        }

        @Override
        public DefaultTableCellRenderer getRenderer(ResourceBundle bundle) {
            return new LinkRenderer(bundle);
        }
    }

    private static interface TableData {
        public DefaultTableCellRenderer getRenderer(ResourceBundle var1);
    }
}

