/*
 * Decompiled with CFR 0.152.
 */
package gui.listeners.actions;

import beans.model.BurialPlot;
import beans.model.DataNode;
import beans.model.Deceased;
import beans.model.Location;
import beans.search.BurialPlotSO;
import beans.search.DeceasedSO;
import dao.exceptions.SQLRuntimeException;
import geom.AbstractShape;
import gui.listeners.AbstractPanelListener;
import gui.listeners.Action;
import gui.panels.TreePanel;
import java.sql.SQLException;

public final class TreePanelActions
extends AbstractPanelListener<TreePanel> {
    public TreePanelActions(TreePanel treePanel) {
        super(treePanel);
        this.register("searchToday", new TodaySearchAction());
        this.register("selectedShape", new SelectShapeAction());
        this.register("burialPlotPostSave", new BurialPlotPostSaveAction());
        this.register("burialPlotPostDelete", new BurialPlotPostDeleteAction());
        this.register("locationPostSave", new LocationPostSaveAction());
        this.register("locationPostDelete", new LocationPostDeleteAction());
        this.register("searchBurialPlot", new BuriaPlotSearchAction());
        this.register("deceasedPostSave", new DeceasedPostSaveAction());
        this.register("deceasedPostDelete", new DeceasedPostDeleteAction());
        this.register("searchDeceased", new DeceasedSearchAction());
        this.register("clickLink", new LinkAction());
        TreeResetAction treeResetAction = new TreeResetAction();
        this.register("endResetDb", treeResetAction);
        this.register("endExport", treeResetAction);
        this.register("endImport", treeResetAction);
        this.register("endMapImport", treeResetAction);
    }

    private final class LinkAction
    implements Action<DataNode> {
        private LinkAction() {
        }

        @Override
        public void execute(DataNode node) {
            try {
                node.displayData((TreePanel)TreePanelActions.this.getPanel());
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
        }
    }

    private final class SelectShapeAction
    implements Action<AbstractShape> {
        private SelectShapeAction() {
        }

        private void selectShape(AbstractShape shape) throws SQLException {
            if (shape == null) {
                ((TreePanel)TreePanelActions.this.getPanel()).resetTree();
            } else {
                ((TreePanel)TreePanelActions.this.getPanel()).findBy(shape.getHandle());
            }
        }

        @Override
        public void execute(AbstractShape shape) {
            ((TreePanel)TreePanelActions.this.getPanel()).setFromMap(true);
            try {
                this.selectShape(shape);
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
            finally {
                ((TreePanel)TreePanelActions.this.getPanel()).setFromMap(false);
            }
        }
    }

    private final class DeceasedSearchAction
    implements Action<DeceasedSO> {
        private DeceasedSearchAction() {
        }

        @Override
        public void execute(DeceasedSO deceasedSO) {
            try {
                ((TreePanel)TreePanelActions.this.getPanel()).findBy(deceasedSO);
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
        }
    }

    private final class TreeResetAction
    implements Action {
        private TreeResetAction() {
        }

        public void execute(Object o) {
            try {
                ((TreePanel)TreePanelActions.this.getPanel()).resetTree();
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
        }
    }

    private final class BuriaPlotSearchAction
    implements Action<BurialPlotSO> {
        private BuriaPlotSearchAction() {
        }

        @Override
        public void execute(BurialPlotSO burialPlotSO) {
            try {
                ((TreePanel)TreePanelActions.this.getPanel()).findBy(burialPlotSO);
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
        }
    }

    private final class DeceasedPostDeleteAction
    implements Action<Deceased> {
        private DeceasedPostDeleteAction() {
        }

        @Override
        public void execute(Deceased deceased) {
            try {
                ((TreePanel)TreePanelActions.this.getPanel()).findBy(deceased.getBurialPlot());
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
        }
    }

    private final class DeceasedPostSaveAction
    implements Action<Deceased> {
        private DeceasedPostSaveAction() {
        }

        @Override
        public void execute(Deceased deceased) {
            try {
                ((TreePanel)TreePanelActions.this.getPanel()).findBy(deceased);
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
        }
    }

    private final class LocationPostDeleteAction
    implements Action {
        private LocationPostDeleteAction() {
        }

        public void execute(Object o) {
            try {
                ((TreePanel)TreePanelActions.this.getPanel()).resetTree();
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
        }
    }

    private final class LocationPostSaveAction
    implements Action<Location> {
        private LocationPostSaveAction() {
        }

        @Override
        public void execute(Location location) {
            try {
                ((TreePanel)TreePanelActions.this.getPanel()).findBy(location);
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
        }
    }

    private final class BurialPlotPostDeleteAction
    implements Action<BurialPlot> {
        private BurialPlotPostDeleteAction() {
        }

        @Override
        public void execute(BurialPlot burialPlot) {
            try {
                ((TreePanel)TreePanelActions.this.getPanel()).findBy(burialPlot.getLocation());
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
        }
    }

    private final class BurialPlotPostSaveAction
    implements Action<BurialPlot> {
        private BurialPlotPostSaveAction() {
        }

        @Override
        public void execute(BurialPlot burialPlot) {
            try {
                ((TreePanel)TreePanelActions.this.getPanel()).findBy(burialPlot);
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
        }
    }

    private final class TodaySearchAction
    implements Action<BurialPlotSO> {
        private TodaySearchAction() {
        }

        @Override
        public void execute(BurialPlotSO burialPlotSO) {
            try {
                ((TreePanel)TreePanelActions.this.getPanel()).findBy(burialPlotSO);
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
        }
    }
}

