/*
 * Decompiled with CFR 0.152.
 */
package gui.listeners.actions;

import beans.model.Location;
import geom.AbstractShape;
import gui.listeners.AbstractPanelListener;
import gui.listeners.Action;
import gui.panels.MapPanel;
import gui.panels.ToolBar;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public final class MapPanelActions
extends AbstractPanelListener<MapPanel> {
    private final PrinterJob printerJob = PrinterJob.getPrinterJob();

    public MapPanelActions(MapPanel mapPanel) {
        super(mapPanel);
        this.register("selectLayers", new SelectLayersAction());
        this.register("selectLocation", new SelectLocationAction());
        this.register("resetButton", new ResetButtonAction());
        this.register("centerButton", new CenterButtonAction());
        this.register("zoomIn", new ZoomInAction());
        this.register("zoomOut", new ZoomOutAction());
        this.register("zoomFit", new ZoomResetAction());
        this.register("rotateLeft", new RotateLeftAction());
        this.register("rotateRight", new RotateRightAction());
        this.register("switchColor", new SwitchColorAction());
        this.register("print", new PrintAction());
        this.register("displayPageFormat", new DisplayPageFormatAction());
        this.register("displayPageSetup", new DisplayPageSetupAction());
    }

    private final class DisplayPageSetupAction
    implements Action {
        private DisplayPageSetupAction() {
        }

        public void execute(Object o) {
            ((MapPanel)MapPanelActions.this.getPanel()).setPageFormat(MapPanelActions.this.printerJob.pageDialog(((MapPanel)MapPanelActions.this.getPanel()).getPageFormat()));
            ((MapPanel)MapPanelActions.this.getPanel()).repaint();
        }
    }

    private final class DisplayPageFormatAction
    implements Action<Boolean> {
        private DisplayPageFormatAction() {
        }

        @Override
        public void execute(Boolean b) {
            ((MapPanel)MapPanelActions.this.getPanel()).displayPageFormat(b);
            ((MapPanel)MapPanelActions.this.getPanel()).repaint();
        }
    }

    private final class PrintAction
    implements Action {
        private PrintAction() {
        }

        public void execute(Object o) {
            MapPanelActions.this.printerJob.setPrintable((Printable)MapPanelActions.this.getPanel(), ((MapPanel)MapPanelActions.this.getPanel()).getPageFormat());
            if (MapPanelActions.this.printerJob.printDialog()) {
                try {
                    MapPanelActions.this.printerJob.print();
                }
                catch (PrinterException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    private final class SwitchColorAction
    implements Action<Boolean> {
        private SwitchColorAction() {
        }

        @Override
        public void execute(Boolean b) {
            ((MapPanel)MapPanelActions.this.getPanel()).setColorHandler(ToolBar.getColorHandler(b));
            ((MapPanel)MapPanelActions.this.getPanel()).repaint();
        }
    }

    private final class ZoomResetAction
    implements Action {
        private ZoomResetAction() {
        }

        public void execute(Object o) {
            ((MapPanel)MapPanelActions.this.getPanel()).reset();
            ((MapPanel)MapPanelActions.this.getPanel()).repaint();
        }
    }

    private final class RotateRightAction
    implements Action {
        private RotateRightAction() {
        }

        public void execute(Object o) {
            try {
                ((MapPanel)MapPanelActions.this.getPanel()).rotateRight();
                ((MapPanel)MapPanelActions.this.getPanel()).repaint();
            }
            catch (NoninvertibleTransformException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private final class RotateLeftAction
    implements Action {
        private RotateLeftAction() {
        }

        public void execute(Object o) {
            try {
                ((MapPanel)MapPanelActions.this.getPanel()).rotateLeft();
                ((MapPanel)MapPanelActions.this.getPanel()).repaint();
            }
            catch (NoninvertibleTransformException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private final class ZoomOutAction
    implements Action {
        private ZoomOutAction() {
        }

        public void execute(Object o) {
            try {
                ((MapPanel)MapPanelActions.this.getPanel()).zoomOut();
                ((MapPanel)MapPanelActions.this.getPanel()).repaint();
            }
            catch (NoninvertibleTransformException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private final class ZoomInAction
    implements Action {
        private ZoomInAction() {
        }

        public void execute(Object o) {
            try {
                ((MapPanel)MapPanelActions.this.getPanel()).zoomIn();
                ((MapPanel)MapPanelActions.this.getPanel()).repaint();
            }
            catch (NoninvertibleTransformException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private final class CenterButtonAction
    implements Action {
        private CenterButtonAction() {
        }

        public void execute(Object o) {
            try {
                AbstractShape shape = ((MapPanel)MapPanelActions.this.getPanel()).getSelectedShape();
                if (shape != null) {
                    ((MapPanel)MapPanelActions.this.getPanel()).center(shape.getPosition());
                    ((MapPanel)MapPanelActions.this.getPanel()).repaint();
                }
            }
            catch (NoninvertibleTransformException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private final class ResetButtonAction
    implements Action {
        private ResetButtonAction() {
        }

        public void execute(Object o) {
            ((MapPanel)MapPanelActions.this.getPanel()).setSelectedShape(null);
            ((MapPanel)MapPanelActions.this.getPanel()).repaint();
        }
    }

    private final class SelectLocationAction
    implements Action<Location> {
        private SelectLocationAction() {
        }

        private String getDxfHandle(Location location) {
            return location != null ? location.getDxfHandle() : null;
        }

        @Override
        public void execute(Location location) {
            ((MapPanel)MapPanelActions.this.getPanel()).selectShape(this.getDxfHandle(location));
            ((MapPanel)MapPanelActions.this.getPanel()).repaint();
        }
    }

    private final class SelectLayersAction
    implements Action {
        private SelectLayersAction() {
        }

        public void execute(Object o) {
            ((MapPanel)MapPanelActions.this.getPanel()).repaint();
        }
    }
}

