/*
 * Decompiled with CFR 0.152.
 */
package gui.handlers.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration.Configuration;

public final class DXFConfig {
    private final String path;
    private final String encoding;
    private final String authVar;
    private final String interactiveLayer;
    private final String numerotationLayer;
    private final String interactiveType;
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String DEFAULT_AUTH_VAR = "$ACADAUTH";
    public static final String DEFAULT_INTERACTIVE = "CONCESSIONS";
    public static final String DEFAULT_NUMEROTATION = "NUMEROTATION";
    public static final String DEFAULT_TYPE = "LWPOLYLINE";
    private final List<String> excludeLayers;

    public DXFConfig(Configuration config) {
        this.path = config.getString("dir.files", "files") + File.separator + config.getString("file.dxf.name", "data.dxf");
        this.encoding = config.getString("dxf_encoding", DEFAULT_ENCODING);
        this.authVar = config.getString("file.dxf.auth_var", DEFAULT_AUTH_VAR);
        this.interactiveLayer = config.getString("layers.interactive", DEFAULT_INTERACTIVE);
        this.numerotationLayer = config.getString("layers.numeroration", DEFAULT_NUMEROTATION);
        this.interactiveType = config.getString("layers.interactive.type", DEFAULT_TYPE);
        this.excludeLayers = Arrays.asList(config.getStringArray("layers.exclude"));
    }

    public String getAuthVar() {
        return this.authVar;
    }

    public String getPath() {
        return this.path;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getInteractiveLayer() {
        return this.interactiveLayer;
    }

    public String getInteractiveType() {
        return this.interactiveType;
    }

    public String getNumerotationLayer() {
        return this.numerotationLayer;
    }

    public List<String> getExcludeLayers() {
        return this.excludeLayers;
    }

    public File toFile() throws FileNotFoundException {
        File file = new File(this.path);
        if (file.isFile()) {
            return file;
        }
        throw new FileNotFoundException();
    }
}

