/*
 * Decompiled with CFR 0.152.
 */
package gui.handlers;

import geom.entities.shapes.Viewport;
import gui.handlers.config.TransformConfig;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.apache.commons.configuration.Configuration;

public final class TransformHandler {
    private final AffineTransform transform;
    private final Viewport viewport;
    private final TransformConfig transformConfig;
    private Dimension2D panelSize;

    public TransformHandler(Viewport viewport, Configuration configuration) {
        this.viewport = viewport;
        this.transform = new AffineTransform();
        this.transformConfig = new TransformConfig(configuration);
    }

    public void setPanelSize(Dimension2D panelSize) {
        this.panelSize = panelSize;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public Dimension2D getPanelSize() {
        return this.panelSize;
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public void init() {
        double scaleFactor = this.getScaleFactor();
        double tx = this.panelSize.getWidth() / 2.0;
        double ty = this.panelSize.getHeight() / 2.0;
        this.transform.setToTranslation(tx, ty);
        this.transform.scale(scaleFactor, -scaleFactor);
        this.transform.translate(-this.viewport.getCenterX(), -this.viewport.getCenterY());
        this.transform.rotate(this.viewport.getTwistAngle());
    }

    private double getScaleFactor() {
        double panelAspect = this.panelSize.getWidth() / this.panelSize.getHeight();
        if (this.viewport.getAspectRatio() >= panelAspect) {
            return this.panelSize.getWidth() / this.viewport.getWidth();
        }
        return this.panelSize.getHeight() / this.viewport.getHeight();
    }

    public Point2D inverseTransform(Point2D srcPoint) throws NoninvertibleTransformException {
        Point2D.Double dstPoint = new Point2D.Double();
        this.transform.inverseTransform(srcPoint, dstPoint);
        return dstPoint;
    }

    public void translate(double deltaX, double deltaY) {
        this.transform.translate(deltaX, deltaY);
    }

    public Point2D computeCenterPoint(Dimension2D panelSize) throws NoninvertibleTransformException {
        return this.inverseTransform(new Point2D.Double(panelSize.getWidth() / 2.0, panelSize.getHeight() / 2.0));
    }

    public void center(Dimension2D panelSize) throws NoninvertibleTransformException {
        Point2D oldCenter = this.computeCenterPoint(this.panelSize);
        Point2D newCenter = this.computeCenterPoint(panelSize);
        double deltaX = newCenter.getX() - oldCenter.getX();
        double deltaY = newCenter.getY() - oldCenter.getY();
        this.transform.translate(deltaX, deltaY);
    }

    public void center(Point2D newCenter) throws NoninvertibleTransformException {
        Point2D oldCenter = this.computeCenterPoint(this.panelSize);
        double deltaX = oldCenter.getX() - newCenter.getX();
        double deltaY = oldCenter.getY() - newCenter.getY();
        this.transform.translate(deltaX, deltaY);
    }

    private void zoom(Point2D target, double factor) {
        if (factor <= 0.0) {
            throw new IllegalArgumentException("Zoom factor must be positive");
        }
        this.transform.translate(target.getX(), target.getY());
        this.transform.scale(factor, factor);
        this.transform.translate(-target.getX(), -target.getY());
    }

    public void zoomIn() throws NoninvertibleTransformException {
        this.zoom(this.computeCenterPoint(this.panelSize), this.transformConfig.getZoomFactor());
    }

    public void zoomOut() throws NoninvertibleTransformException {
        this.zoom(this.computeCenterPoint(this.panelSize), 1.0 / this.transformConfig.getZoomFactor());
    }

    private void rotate(double value) throws NoninvertibleTransformException {
        Point2D p = this.computeCenterPoint(this.panelSize);
        this.transform.rotate(Math.toRadians(value), p.getX(), p.getY());
    }

    public void rotateLeft() throws NoninvertibleTransformException {
        this.rotate(this.transformConfig.getRotateFactor());
    }

    public void rotateRight() throws NoninvertibleTransformException {
        this.rotate(-this.transformConfig.getRotateFactor());
    }
}

