/*
 * Decompiled with CFR 0.152.
 */
package gui.handlers;

import context.Context;
import geom.AbstractShape;
import geom.CompositeShape;
import geom.entities.Layer;
import geom.entities.ShapesContainer;
import geom.entities.shapes.Viewport;
import geom.exceptions.DxfTypeNotFoundException;
import gui.exceptions.AuthorizeFileException;
import gui.handlers.TransformHandler;
import gui.handlers.config.DXFConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFLayer;
import org.kabeja.dxf.DXFVariable;
import org.kabeja.dxf.DXFViewport;
import org.kabeja.parser.ParseException;
import org.kabeja.parser.Parser;
import org.kabeja.parser.ParserBuilder;

public final class DocumentHandler {
    private final DXFDocument document;
    private final DXFConfig DXFConfig;
    private final Configuration configuration;
    private final CompositeShape layers = new ShapesContainer();
    public static final String FULL = "full";
    public static final String ACTIVE = "active";
    public static final String HEADER = "HEADER";
    public static final Log LOGGER = LogFactory.getLog(DocumentHandler.class);

    public DocumentHandler(Context context) throws ParseException, FileNotFoundException {
        this.configuration = context.getConfiguration();
        this.DXFConfig = new DXFConfig(this.configuration);
        this.document = this.parse();
    }

    public DXFDocument getDocument() {
        return this.document;
    }

    public CompositeShape getLayers() {
        return this.layers;
    }

    public DXFDocument parse() throws ParseException, FileNotFoundException {
        Parser parser = ParserBuilder.createDefaultParser();
        parser.parse(this.DXFConfig.toFile().getPath(), this.DXFConfig.getEncoding());
        return parser.getDocument();
    }

    public boolean isDxfFileAuth() {
        DXFVariable authVar = this.document.getDXFHeader().getVariable(this.DXFConfig.getAuthVar());
        if (authVar == null) {
            return false;
        }
        return authVar.getIntegerValue("70") == 1;
    }

    private static int findHeaderIndex(List<String> lines) throws AuthorizeFileException {
        int index = 0;
        for (String line : lines) {
            if (line.contains(HEADER)) {
                return index;
            }
            ++index;
        }
        throw new AuthorizeFileException("HEADER not found");
    }

    private void addAuthVar(List<String> lines, int index) {
        lines.add(++index, "  9");
        lines.add(++index, this.DXFConfig.getAuthVar());
        lines.add(++index, " 70");
        lines.add(++index, "  1");
    }

    private List<String> readDxfFile() throws AuthorizeFileException {
        try {
            return FileUtils.readLines((File)this.DXFConfig.toFile(), (String)this.DXFConfig.getEncoding());
        }
        catch (IOException ex) {
            throw new AuthorizeFileException("Reading file error", ex);
        }
    }

    private void writeDxfFile(List<String> lines) throws AuthorizeFileException {
        try {
            FileUtils.writeLines((File)this.DXFConfig.toFile(), (String)this.DXFConfig.getEncoding(), lines);
        }
        catch (IOException ex) {
            throw new AuthorizeFileException("Writing file error", ex);
        }
    }

    public void authorizeDxf() throws AuthorizeFileException {
        List<String> lines = this.readDxfFile();
        this.addAuthVar(lines, DocumentHandler.findHeaderIndex(lines));
        this.writeDxfFile(lines);
    }

    public List<DXFLayer> getDxfLayers() {
        ArrayList<DXFLayer> list = new ArrayList<DXFLayer>();
        Iterator iterator = this.document.getDXFLayerIterator();
        while (iterator.hasNext()) {
            list.add((DXFLayer)iterator.next());
        }
        return list;
    }

    public void loadLayers() {
        long start = System.currentTimeMillis();
        Iterator iterator = this.document.getDXFLayerIterator();
        while (iterator.hasNext()) {
            DXFLayer dxfLayer = (DXFLayer)iterator.next();
            if (this.DXFConfig.getExcludeLayers().contains(dxfLayer.getName())) continue;
            CompositeShape layer = this.loadLayer(dxfLayer);
            layer.setInteractive(this.DXFConfig.getInteractiveLayer().equals(dxfLayer.getName()));
            this.layers.add(layer);
        }
        this.layers.sort(new LayerComparator());
        this.layers.setInteractive(true);
        long time = System.currentTimeMillis() - start;
        LOGGER.info((Object)(this.layers.size() + " layers loaded in " + time + " ms"));
    }

    public CompositeShape loadLayer(DXFLayer dxfLayer) {
        Iterator iterator = dxfLayer.getDXFEntityTypeIterator();
        Layer result = new Layer(dxfLayer);
        LOGGER.debug((Object)("Loading layer [" + dxfLayer.getName() + "]"));
        while (iterator.hasNext()) {
            String type = (String)iterator.next();
            LOGGER.debug((Object)("-> Loading type [" + type + "]"));
            List dxfEntities = dxfLayer.getDXFEntities(type);
            CompositeShape entities = this.loadEntities(dxfEntities);
            entities.setInteractive(this.DXFConfig.getInteractiveType().equals(type));
            result.add(entities);
        }
        return result;
    }

    public CompositeShape loadEntities(List<DXFEntity> dxfEntities) {
        ShapesContainer result = new ShapesContainer();
        for (DXFEntity dxfEntity : dxfEntities) {
            if (!dxfEntity.isModelSpace()) continue;
            try {
                AbstractShape shape = AbstractShape.getShape(dxfEntity);
                shape.setInteractive(true);
                result.add(shape);
            }
            catch (DxfTypeNotFoundException ex) {
                LOGGER.debug((Object)("[" + ex.getType() + "] type not supported"));
            }
        }
        LOGGER.debug((Object)("-> " + result.size() + " entities loaded"));
        return result;
    }

    public DXFViewport findActiveViewport() {
        DXFViewport viewport = null;
        Iterator vpIterator = this.document.getDXFViewportIterator();
        boolean found = false;
        while (vpIterator.hasNext() && !found) {
            DXFViewport v = (DXFViewport)vpIterator.next();
            if (!v.isActive()) continue;
            viewport = v;
            found = true;
        }
        return viewport;
    }

    public Viewport getFullViewport() {
        return new Viewport(Viewport.convert(this.document.getBounds(true)));
    }

    public Viewport getActiveViewport() {
        return new Viewport(this.findActiveViewport());
    }

    public Viewport getConfigViewport() {
        switch (this.configuration.getString("viewport", FULL)) {
            default: {
                return this.getFullViewport();
            }
            case "active": 
        }
        return this.getActiveViewport();
    }

    public TransformHandler createTransformHandler() {
        return new TransformHandler(this.getConfigViewport(), this.configuration);
    }

    public DXFConfig getDXFConfig() {
        return this.DXFConfig;
    }

    private static final class LayerComparator
    implements Comparator<Layer>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private LayerComparator() {
        }

        @Override
        public int compare(Layer layer1, Layer layer2) {
            return layer1.getName().compareTo(layer2.getName());
        }
    }
}

