/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs.menu.utils;

import com.jgoodies.validation.Severity;
import com.jgoodies.validation.ValidationMessage;
import gui.components.JIcon;
import gui.components.factory.component.ComponentFactory;
import java.awt.Color;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public final class StyleUtils {
    public static void addStyles(ComponentFactory componentFactory, StyledDocument doc) {
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style redStyle = doc.addStyle("red", def);
        StyleConstants.setForeground(redStyle, Color.RED);
        Style blackStyle = doc.addStyle("black", def);
        StyleConstants.setForeground(blackStyle, Color.BLACK);
        Style okStyle = doc.addStyle("ok", def);
        StyleConstants.setIcon(okStyle, componentFactory.imageIcon(new JIcon("tick.png")));
        Style errorStyle = doc.addStyle("error", def);
        StyleConstants.setIcon(errorStyle, componentFactory.imageIcon(new JIcon("cross.png")));
        Style infoStyle = doc.addStyle("info", def);
        StyleConstants.setIcon(infoStyle, componentFactory.imageIcon(new JIcon("about.png")));
        Style validStyle = doc.addStyle("validation", def);
        StyleConstants.setIcon(validStyle, componentFactory.imageIcon(new JIcon("cross-small.png")));
    }

    public static void insertOk(StyledDocument doc, String message) {
        StyleUtils.insertMessage(message, new OkStyle(doc));
    }

    public static void insertError(StyledDocument doc, String message) {
        StyleUtils.insertMessage(message, new ErrorStyle(doc));
    }

    public static void insertValidation(StyledDocument doc, String message) {
        StyleUtils.insertMessage(message, new ValidationStyle(doc));
    }

    public static void insertInfo(StyledDocument doc, String message) {
        StyleUtils.insertMessage(message, new InfoStyle(doc));
    }

    private static boolean isValidation(String text) {
        return text.startsWith("[icon]");
    }

    private static String getValidation(String text) {
        return text.substring("[icon]".length());
    }

    public static void insertMessage(StyledDocument document, ValidationMessage message) {
        if (message.severity() == Severity.ERROR) {
            if (StyleUtils.isValidation(message.formattedText())) {
                StyleUtils.insertValidation(document, StyleUtils.getValidation(message.formattedText()));
            } else {
                StyleUtils.insertError(document, message.formattedText());
            }
        } else {
            StyleUtils.insertOk(document, message.formattedText());
        }
    }

    public static void insertMessage(String message, MessageStyle style) {
        try {
            style.insertPrefix();
            style.insertIcon();
            style.insertMessage(message);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static final class ValidationStyle
    extends MessageStyle {
        public ValidationStyle(StyledDocument doc) {
            super("validation", "red", doc, "    ");
        }
    }

    public static final class InfoStyle
    extends MessageStyle {
        public InfoStyle(StyledDocument doc) {
            super("info", "black", doc);
        }
    }

    public static final class ErrorStyle
    extends MessageStyle {
        public ErrorStyle(StyledDocument doc) {
            super("error", "red", doc);
        }
    }

    public static final class OkStyle
    extends MessageStyle {
        public OkStyle(StyledDocument doc) {
            super("ok", "black", doc);
        }
    }

    public static abstract class MessageStyle {
        private final String icon;
        private final String text;
        private final String prefix;
        private final StyledDocument doc;

        public MessageStyle(String icon, String text, StyledDocument doc) {
            this(icon, text, doc, "");
        }

        public MessageStyle(String icon, String text, StyledDocument doc, String prefix) {
            this.icon = icon;
            this.text = text;
            this.doc = doc;
            this.prefix = prefix;
        }

        public void insertMessage(String message) throws BadLocationException {
            this.doc.insertString(this.doc.getLength(), message.concat("\n"), this.doc.getStyle(this.text));
        }

        public void insertIcon() throws BadLocationException {
            this.doc.insertString(this.doc.getLength(), "\ufffc", this.doc.getStyle(this.icon));
        }

        public void insertPrefix() throws BadLocationException {
            if (!this.prefix.isEmpty()) {
                this.doc.insertString(this.doc.getLength(), this.prefix, this.doc.getStyle(this.text));
            }
        }
    }
}

