/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs.menu.i18n;

import com.jgoodies.validation.ValidationMessage;
import com.jgoodies.validation.ValidationResult;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public final class I18nValidationResult {
    private final ValidationResult validationResult;
    private final ResourceBundle resourceBundle;
    public static final String PLACEHOLDER = "[icon]";

    public I18nValidationResult(ResourceBundle resourceBundle) {
        this(resourceBundle, new ValidationResult());
    }

    public I18nValidationResult(ResourceBundle resourceBundle, ValidationResult validationResult) {
        this.resourceBundle = resourceBundle;
        this.validationResult = validationResult;
    }

    public I18nValidationResult addInfo(String text) {
        this.validationResult.addInfo(this.resourceBundle.getString(text));
        return this;
    }

    public I18nValidationResult addInfo(String text, String key) {
        this.validationResult.addInfo(this.resourceBundle.getString(text), (Object)key);
        return this;
    }

    public I18nValidationResult addInfoMF(String text, Object ... params) {
        this.validationResult.addInfo(MessageFormat.format(this.resourceBundle.getString(text), params));
        return this;
    }

    public I18nValidationResult addError(String text) {
        this.validationResult.addError(this.resourceBundle.getString(text));
        return this;
    }

    public I18nValidationResult addError(String text, String key) {
        this.validationResult.addError(this.resourceBundle.getString(text), (Object)key);
        return this;
    }

    public I18nValidationResult addErrorMF(String text, Object ... params) {
        this.validationResult.addError(MessageFormat.format(this.resourceBundle.getString(text), params));
        return this;
    }

    public I18nValidationResult addValidationErrors(ValidationResult result) {
        for (ValidationMessage message : result) {
            this.validationResult.addError(PLACEHOLDER.concat(message.formattedText()));
        }
        return this;
    }

    public ValidationResult getValidationResult() {
        return this.validationResult;
    }
}

