/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs.menu;

import context.Context;
import java.awt.Frame;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public final class TodaySearchDialog {
    private final String title;
    private final String message;
    private final int optionType;
    private final int messageType;
    private final Object[] options;
    private final Frame owner;

    public TodaySearchDialog(Context context, int count) {
        ResourceBundle rb = context.getResourceBundle();
        this.owner = context.getMainFrame();
        this.title = rb.getString("search.today.title");
        switch (count) {
            case 0: {
                this.message = rb.getString("search.today.none");
                this.options = new Object[1];
                this.options[0] = rb.getString("search.today.close");
                this.optionType = 0;
                this.messageType = 1;
                break;
            }
            case 1: {
                this.message = rb.getString("search.today.one");
                this.options = new Object[2];
                this.options[0] = rb.getString("search.today.show");
                this.options[1] = rb.getString("search.today.close");
                this.optionType = 0;
                this.messageType = 2;
                break;
            }
            default: {
                this.message = count + " " + rb.getString("search.today.many");
                this.options = new Object[2];
                this.options[0] = rb.getString("search.today.show");
                this.options[1] = rb.getString("search.today.close");
                this.optionType = 0;
                this.messageType = 2;
            }
        }
    }

    public int show() {
        return JOptionPane.showOptionDialog(this.owner, this.message, this.title, this.optionType, this.messageType, null, this.options, this.options[0]);
    }
}

