/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs.menu;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import context.Context;
import dao.exceptions.SQLRuntimeException;
import dao.model.BurialPlotDao;
import dao.model.DeceasedDao;
import dao.model.LocationDao;
import gui.components.JIcon;
import gui.components.factory.component.ComponentFactory;
import gui.dialogs.AbstractDialog;
import gui.dialogs.headers.IconHeader;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.concurrent.ExecutionException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.SwingWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ResetDbDialog
extends AbstractDialog {
    private final JButton resetButton;
    private final JRadioButton locationRadio;
    private final JRadioButton burialPlotRadio;
    private final JRadioButton deceasedRadio;
    private final ButtonGroup group = new ButtonGroup();
    private final JProgressBar progressBar = new JProgressBar(0, 100);
    public static final Log LOGGER = LogFactory.getLog(ResetDbDialog.class);
    public static final String LAYOUT = "r:p, 4dlu, 170dlu, 4dlu, 40dlu:g";
    public static final String PROP_END_RESET_DB = "endResetDb";

    public ResetDbDialog(Context context) {
        super(context, new IconHeader(context, "reset_db.title", "bin-metal.png"));
        ComponentFactory cf = context.getComponentFactory();
        this.resetButton = cf.button("reset_db.reset", new JIcon("bin-metal.png"));
        this.locationRadio = cf.radioButton("info.location.object");
        this.burialPlotRadio = cf.radioButton("info.burialplot.object");
        this.deceasedRadio = cf.radioButton("info.deceased.object", true);
        this.initForm(this.resetButton, LAYOUT);
        this.initComponents();
    }

    private void initComponents() {
        this.getRootPane().setDefaultButton(this.resetButton);
        this.group.add(this.locationRadio);
        this.group.add(this.burialPlotRadio);
        this.group.add(this.deceasedRadio);
        this.deceasedRadio.setSelected(true);
        this.resetButton.addActionListener(new ResetDbAction());
        this.resetButton.addKeyListener(new KeyAction());
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(false);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    protected void buildForm(DefaultFormBuilder builder) {
        builder.appendI15d("export.object", (Component)this.deceasedRadio, 3);
        builder.append("", (Component)this.burialPlotRadio, 3);
        builder.append("", (Component)this.locationRadio, 3);
        builder.appendI15d("export.progress", (Component)this.progressBar, 3);
    }

    @Override
    protected void enableButtons(boolean enable) {
        super.enableButtons(enable);
        this.resetButton.setEnabled(enable);
        this.progressBar.setIndeterminate(!enable);
    }

    private final class KeyAction
    extends AbstractDialog.KeyAction {
        private KeyAction() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            Object source;
            super.keyPressed(e);
            if (e.getKeyCode() == 10 && (source = e.getSource()).equals(ResetDbDialog.this.resetButton)) {
                ResetDbDialog.this.resetButton.doClick();
            }
        }
    }

    private final class ResetDbAction
    implements ActionListener {
        private ResetDbAction() {
        }

        private String getType() {
            if (ResetDbDialog.this.locationRadio.isSelected()) {
                return "Locations";
            }
            if (ResetDbDialog.this.burialPlotRadio.isSelected()) {
                return "Burial Plots";
            }
            return "Deceaseds";
        }

        private int showConfirmDialog(String messageKey, String messageTitle) {
            return JOptionPane.showConfirmDialog(ResetDbDialog.this, ResetDbDialog.this.getContext().getResourceBundle().getString(messageKey), ResetDbDialog.this.getContext().getResourceBundle().getString(messageTitle), 0);
        }

        private void execute() {
            ResetDbDialog.this.enableButtons(false);
            try {
                ResetDbTask task = new ResetDbTask(this.getType());
                task.execute();
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
            finally {
                ResetDbDialog.this.enableButtons(true);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int n = this.showConfirmDialog("reset_db.confirm", "reset_db.title");
            if (n == 0) {
                LOGGER.info((Object)"Resetting Database : ".concat(this.getType()));
                this.execute();
            }
        }
    }

    private class ResetDbTask
    extends SwingWorker<Void, Void> {
        private final LocationDao locationDao;
        private final BurialPlotDao burialPlotDao;
        private final DeceasedDao deceasedDao;
        private final String type;
        public static final String LOCATIONS = "Locations";
        public static final String BURIAL_PLOTS = "Burial Plots";
        public static final String DECEASEDS = "Deceaseds";

        public ResetDbTask(String type) throws SQLException {
            this.locationDao = ResetDbDialog.this.getContext().getDaoFactory().getLocationDAO();
            this.burialPlotDao = ResetDbDialog.this.getContext().getDaoFactory().getBurialPlotDAO();
            this.deceasedDao = ResetDbDialog.this.getContext().getDaoFactory().getDeceasedDAO();
            this.type = type;
        }

        @Override
        protected Void doInBackground() throws Exception {
            ResetDbDialog.this.getContext().getDaoFactory().callInTransaction(() -> {
                switch (this.type) {
                    case "Locations": {
                        this.deceasedDao.dropTable(true);
                        this.burialPlotDao.dropTable(true);
                        this.locationDao.dropTable(true);
                        this.locationDao.createTable();
                        this.burialPlotDao.createTable();
                        this.deceasedDao.createTable();
                        break;
                    }
                    case "Burial Plots": {
                        this.deceasedDao.dropTable(true);
                        this.burialPlotDao.dropTable(true);
                        this.burialPlotDao.createTable();
                        this.deceasedDao.createTable();
                        break;
                    }
                    default: {
                        this.deceasedDao.dropTable(true);
                        this.deceasedDao.createTable();
                    }
                }
                return null;
            });
            return null;
        }

        @Override
        protected void done() {
            try {
                this.get();
                Toolkit.getDefaultToolkit().beep();
                ResetDbDialog.this.progressBar.setValue(100);
                ResetDbDialog.this.firePropertyChange(ResetDbDialog.PROP_END_RESET_DB, null, true);
            }
            catch (InterruptedException | ExecutionException ex) {
                ResetDbDialog.this.progressBar.setValue(0);
                throw new RuntimeException(ex);
            }
            finally {
                ResetDbDialog.this.enableButtons(true);
            }
        }
    }
}

