/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs.menu;

import beans.model.AbstractModel;
import beans.model.Location;
import beans.model.LocationType;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.validation.ValidationMessage;
import com.jgoodies.validation.ValidationResult;
import context.Context;
import dao.exceptions.SQLRuntimeException;
import dao.model.LocationDao;
import dao.model.LocationTypeDao;
import geom.AbstractShape;
import geom.CompositeShape;
import gui.components.JIcon;
import gui.components.factory.component.ComponentFactory;
import gui.dialogs.AbstractDialog;
import gui.dialogs.forms.beans.validators.AnnotationValidator;
import gui.dialogs.headers.IconHeader;
import gui.dialogs.menu.ExportDialog;
import gui.dialogs.menu.i18n.I18nResultCount;
import gui.dialogs.menu.i18n.I18nValidationResult;
import gui.dialogs.menu.utils.StyleUtils;
import gui.exceptions.LayerNotFoundException;
import gui.handlers.DocumentHandler;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFLayer;
import org.kabeja.dxf.DXFText;
import org.kabeja.dxf.helpers.Point;

public final class MapImportDialog
extends AbstractDialog {
    private final JButton startButton;
    private final JRadioButton centerRadio = new JRadioButton("Center Point", true);
    private final JRadioButton insertRadio = new JRadioButton("Insert Point");
    private final ButtonGroup methodGroup = new ButtonGroup();
    private final JTextPane resultsPane = new JTextPane();
    private final JProgressBar progressBar = new JProgressBar(0, 100);
    private final DocumentHandler documentHandler;
    public static final Log LOGGER = LogFactory.getLog(MapImportDialog.class);
    public static final String LAYOUT = "r:p, 4dlu, 220dlu, 4dlu, 40dlu:g";
    public static final String PROP_END_MAP_IMPORT = "endMapImport";

    public MapImportDialog(Context context, DocumentHandler documentHandler) {
        super(context, new IconHeader(context, "map_import.title", "table-import.png"));
        this.documentHandler = documentHandler;
        ComponentFactory cf = context.getComponentFactory();
        this.startButton = cf.button("import.start", new JIcon("import.png"));
        this.initForm(this.startButton, LAYOUT);
        this.initComponents();
    }

    private void initComponents() {
        this.getRootPane().setDefaultButton(this.startButton);
        this.startButton.addActionListener(new MapImportAction());
        this.startButton.addKeyListener(new KeyAction());
        this.methodGroup.add(this.centerRadio);
        this.methodGroup.add(this.insertRadio);
        this.resultsPane.setEditable(false);
        StyleUtils.addStyles(this.getContext().getComponentFactory(), this.resultsPane.getStyledDocument());
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    protected void buildForm(DefaultFormBuilder builder) {
        CellConstraints cc = new CellConstraints();
        JScrollPane scrollPane = new JScrollPane(this.resultsPane);
        builder.appendI15d("export.type", (Component)this.centerRadio, 3);
        builder.append("", (Component)this.insertRadio, 3);
        builder.appendI15d("import.output");
        builder.appendRow(RowSpec.decode((String)"80dlu"));
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 2));
        builder.nextLine(2);
        builder.appendI15d("export.progress", (Component)this.progressBar, 3);
    }

    @Override
    protected void enableButtons(boolean enable) {
        super.enableButtons(enable);
        this.startButton.setEnabled(enable);
    }

    private final class KeyAction
    extends AbstractDialog.KeyAction {
        private KeyAction() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            Object source;
            super.keyPressed(e);
            if (e.getKeyCode() == 10 && (source = e.getSource()).equals(MapImportDialog.this.startButton)) {
                MapImportDialog.this.startButton.doClick();
            }
        }
    }

    private final class MapImportAction
    implements ActionListener {
        private MapImportAction() {
        }

        private void showError(String key, Object ... params) {
            JOptionPane.showMessageDialog(MapImportDialog.this, MessageFormat.format(MapImportDialog.this.getContext().getResourceBundle().getString(key), params), MapImportDialog.this.getContext().getResourceBundle().getString("error"), 0);
        }

        private void execute() {
            MapImportDialog.this.enableButtons(false);
            MapImportDialog.this.resultsPane.setText("");
            try {
                MapImportTask task = new MapImportTask();
                task.addPropertyChangeListener(new ExportDialog.ProgressListener(MapImportDialog.this.progressBar));
                task.execute();
            }
            catch (SQLException ex) {
                MapImportDialog.this.enableButtons(true);
                throw new SQLRuntimeException(ex);
            }
            catch (LayerNotFoundException ex) {
                MapImportDialog.this.enableButtons(true);
                this.showError("map_import.layer_error", ex.getLayerName());
                LOGGER.error((Object)"Layer not found : ".concat(ex.getLayerName()));
            }
        }

        private int showConfirmDialog(String messageKey, String messageTitle) {
            return JOptionPane.showConfirmDialog(MapImportDialog.this, MapImportDialog.this.getContext().getResourceBundle().getString(messageKey), MapImportDialog.this.getContext().getResourceBundle().getString(messageTitle), 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int n = this.showConfirmDialog("import.confirm", "import.title");
            if (n == 0) {
                LOGGER.info((Object)"Importing data from map");
                this.execute();
            }
        }
    }

    private class MapImportTask<K extends AbstractModel>
    extends SwingWorker<I18nResultCount, I18nValidationResult> {
        private final LocationDao locationDao;
        private final LocationTypeDao locationTypeDao;
        private final List<DXFText> entities;
        private final int count;
        private final CompositeShape locations;
        private final AnnotationValidator<Location> validator;

        public MapImportTask() throws SQLException, LayerNotFoundException {
            this.locationDao = MapImportDialog.this.getContext().getDaoFactory().getLocationDAO();
            this.locationTypeDao = MapImportDialog.this.getContext().getDaoFactory().getLocationTypeDAO();
            this.entities = this.getTextEntities();
            this.locations = this.getLocations();
            this.count = this.entities.size();
            this.validator = new AnnotationValidator<Location>(MapImportDialog.this.getContext(), Location.class);
        }

        protected int getPercentage(int index) throws SQLException {
            return Math.round((float)index * 100.0f / (float)this.count);
        }

        private DXFLayer getLayer(String name) throws LayerNotFoundException {
            DXFLayer layer = MapImportDialog.this.documentHandler.getDocument().getDXFLayer(name);
            if (layer == null) {
                throw new LayerNotFoundException(name);
            }
            return layer;
        }

        private CompositeShape getLocations() throws LayerNotFoundException {
            DXFLayer layer = this.getLayer(MapImportDialog.this.documentHandler.getDXFConfig().getInteractiveLayer());
            CompositeShape shape = MapImportDialog.this.documentHandler.loadLayer(layer);
            shape.setInteractive(true);
            return shape;
        }

        private List<DXFText> getList(DXFLayer layer, String type) {
            List list = layer.getDXFEntities(type);
            if (list == null) {
                return new ArrayList<DXFText>();
            }
            return list;
        }

        private List<DXFText> getTextEntities() throws LayerNotFoundException {
            DXFLayer layer = this.getLayer(MapImportDialog.this.documentHandler.getDXFConfig().getNumerotationLayer());
            ArrayList<DXFText> result = new ArrayList<DXFText>();
            result.addAll(this.getList(layer, "MTEXT"));
            result.addAll(this.getList(layer, "TEXT"));
            return result;
        }

        private Point2D getCenter(DXFText e) {
            Bounds b = e.getBounds();
            return new Point2D.Double(b.getCenterX(), b.getCenterY());
        }

        private Point2D getInsertPoint(DXFText e) {
            Point p = e.getInsertPoint();
            return new Point2D.Double(p.getX(), p.getY());
        }

        private AbstractShape match(DXFText e) {
            if (MapImportDialog.this.centerRadio.isSelected()) {
                return this.locations.match(this.getCenter(e));
            }
            return this.locations.match(this.getInsertPoint(e));
        }

        @Override
        protected I18nResultCount doInBackground() throws Exception {
            int index = 0;
            int success = 0;
            ResourceBundle resourceBundle = MapImportDialog.this.getContext().getResourceBundle();
            for (DXFText entity : this.entities) {
                this.setProgress(this.getPercentage(++index));
                I18nValidationResult result = new I18nValidationResult(resourceBundle);
                String reference = entity.getTextDocument().getText().trim();
                AbstractShape shape = this.match(entity);
                if (shape == null) {
                    this.publish(result.addErrorMF("map_import.ref_not_matched", reference));
                    continue;
                }
                Location location = new Location();
                location.setDxfHandle(shape.getHandle());
                location.setReference(reference);
                location.setLocationType((LocationType)this.locationTypeDao.queryForId(1));
                location.setCreatedAt(new Date());
                ValidationResult validation = this.validator.validate(location);
                if (validation.hasErrors()) {
                    result.addErrorMF("map_import.validation", shape.getHandle());
                    result.addValidationErrors(validation);
                    this.publish(result);
                    continue;
                }
                this.locationDao.create(location);
                this.publish(result.addInfoMF("map_import.ref_created", reference));
                ++success;
            }
            return new I18nResultCount(resourceBundle, success, index - success);
        }

        @Override
        protected void process(List<I18nValidationResult> chunks) {
            for (I18nValidationResult result : chunks) {
                for (ValidationMessage message : result.getValidationResult()) {
                    StyleUtils.insertMessage(MapImportDialog.this.resultsPane.getStyledDocument(), message);
                }
            }
        }

        @Override
        protected void done() {
            try {
                I18nResultCount resultCount = (I18nResultCount)this.get();
                StyleUtils.insertInfo(MapImportDialog.this.resultsPane.getStyledDocument(), resultCount.getResult());
                Toolkit.getDefaultToolkit().beep();
                LOGGER.info((Object)"Map import results : ".concat(resultCount.getLog()));
                MapImportDialog.this.firePropertyChange(MapImportDialog.PROP_END_MAP_IMPORT, null, true);
            }
            catch (InterruptedException | ExecutionException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                MapImportDialog.this.enableButtons(true);
            }
        }
    }
}

