/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs.menu;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.view.ValidationComponentUtils;
import context.Context;
import gui.components.JIcon;
import gui.components.factory.component.ComponentFactory;
import gui.dialogs.AbstractDialog;
import gui.dialogs.headers.LoginHeader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;

public final class LoginDialog
extends AbstractDialog {
    private final JButton loginButton;
    private final JTextField loginField = new JTextField();
    private final JPasswordField pwdField = new JPasswordField();
    public static final Log LOGGER = LogFactory.getLog(LoginDialog.class);
    public static final String LAYOUT = "r:p, 4dlu, 150dlu:g";
    public static final String KEY_LOGIN = "keyLogin";
    public static final String KEY_PWD = "keyPwd";

    public LoginDialog(Context context) {
        super(context, new LoginHeader(context, "login.title"));
        ComponentFactory cf = context.getComponentFactory();
        this.loginButton = cf.button("login.connect", new JIcon("key.png"));
        this.initForm(this.loginButton, LAYOUT);
        this.initComponents();
    }

    private void initComponents() {
        this.getRootPane().setDefaultButton(this.loginButton);
        this.getCloseButton().setText(this.getContext().getResourceBundle().getString("login.exit"));
        this.getCloseButton().setIcon(this.getContext().getComponentFactory().imageIcon(new JIcon("exit.png")));
        this.loginButton.addActionListener(new LoginAction());
        this.loginButton.addKeyListener(new KeyAction());
        ValidationComponentUtils.setMessageKey((JComponent)this.loginField, (Object)KEY_LOGIN);
        ValidationComponentUtils.setMessageKey((JComponent)this.pwdField, (Object)KEY_PWD);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    protected void buildForm(DefaultFormBuilder builder) {
        builder.appendI15d("login.login", (Component)this.loginField);
        builder.appendI15d("login.password", (Component)this.pwdField);
    }

    @Override
    protected void postClose() {
        System.exit(0);
    }

    private final class KeyAction
    extends AbstractDialog.KeyAction {
        private KeyAction() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            Object source;
            super.keyPressed(e);
            if (e.getKeyCode() == 10 && (source = e.getSource()).equals(LoginDialog.this.loginButton)) {
                LoginDialog.this.loginButton.doClick();
            }
        }
    }

    private final class LoginAction
    implements ActionListener {
        private LoginAction() {
        }

        private UsernamePasswordToken getToken() {
            UsernamePasswordToken token = new UsernamePasswordToken(LoginDialog.this.loginField.getText(), LoginDialog.this.pwdField.getPassword());
            token.setRememberMe(false);
            return token;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ValidationResult result = new ValidationResult();
            UsernamePasswordToken token = this.getToken();
            Subject subject = LoginDialog.this.getContext().getSubject();
            ResourceBundle bundle = LoginDialog.this.getContext().getResourceBundle();
            try {
                subject.login((AuthenticationToken)token);
                LoginDialog.this.dispose();
                LOGGER.info((Object)("[" + subject.getPrincipal() + "] logged in successfully"));
            }
            catch (UnknownAccountException ex) {
                result.addError(bundle.getString("login.error.unknown"), (Object)LoginDialog.KEY_LOGIN);
                LOGGER.info((Object)("[" + token.getUsername() + "] unknown account"));
            }
            catch (IncorrectCredentialsException ex) {
                result.addError(bundle.getString("login.error.password"), (Object)LoginDialog.KEY_PWD);
                LOGGER.info((Object)("[" + token.getUsername() + "] incorrect credentials"));
            }
            catch (LockedAccountException ex) {
                result.addError(bundle.getString("login.error.locked"), (Object)LoginDialog.KEY_LOGIN);
                LOGGER.info((Object)("[" + token.getUsername() + "] account locked"));
            }
            catch (AuthenticationException ex) {
                result.addError(bundle.getString("login.error"));
                LOGGER.error((Object)"Login error", (Throwable)ex);
            }
            LoginDialog.this.validate(result);
        }
    }
}

