/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs.menu;

import beans.model.AbstractModel;
import beans.model.BurialPlot;
import beans.model.BurialPlotType;
import beans.model.DateType;
import beans.model.Deceased;
import beans.model.DeceasedType;
import beans.model.Location;
import beans.model.LocationType;
import com.j256.ormlite.dao.Dao;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.validation.ValidationMessage;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.view.ValidationComponentUtils;
import context.Context;
import dao.exceptions.SQLRuntimeException;
import gui.components.JIcon;
import gui.components.factory.component.ComponentFactory;
import gui.dialogs.AbstractDialog;
import gui.dialogs.forms.beans.validators.AnnotationValidator;
import gui.dialogs.forms.beans.validators.exceptions.AnnotationValidatorException;
import gui.dialogs.forms.beans.validators.testers.InDatabaseTester;
import gui.dialogs.headers.IconHeader;
import gui.dialogs.menu.i18n.I18nResultCount;
import gui.dialogs.menu.i18n.I18nValidationResult;
import gui.dialogs.menu.utils.FileUtils;
import gui.dialogs.menu.utils.StyleUtils;
import gui.exceptions.CsvParseException;
import gui.utils.DateUtils;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ImportDialog
extends AbstractDialog {
    private final JButton startButton;
    private final JButton fileButton;
    private final JRadioButton locationRadio;
    private final JRadioButton burialPlotRadio;
    private final JRadioButton deceasedRadio;
    private final JTextField filePath = new JTextField();
    private final JRadioButton defaultRadio = new JRadioButton("CSV", true);
    private final JRadioButton excelRadio = new JRadioButton("CSV (Excel)");
    private final JRadioButton isoRadio = new JRadioButton("ISO-8859-1");
    private final JRadioButton utf8Radio = new JRadioButton("UTF-8", true);
    private final ButtonGroup formatGroup = new ButtonGroup();
    private final ButtonGroup beanGroup = new ButtonGroup();
    private final ButtonGroup charsetGroup = new ButtonGroup();
    private final JFileChooser fileChooser = new JFileChooser();
    private final JTextPane resultsPane = new JTextPane();
    private final JProgressBar progressBar = new JProgressBar(0, 100);
    private File csvFile = new File("import.csv");
    public static final Log LOGGER = LogFactory.getLog(ImportDialog.class);
    public static final String KEY_FILE = "keyFile";
    public static final String LAYOUT = "r:p, 4dlu, 220dlu, 4dlu, 40dlu:g";
    public static final String PROP_END_IMPORT = "endImport";

    public ImportDialog(Context context) {
        super(context, new IconHeader(context, "import.title", "table-import.png"));
        ComponentFactory cf = context.getComponentFactory();
        this.startButton = cf.button("import.start", new JIcon("import.png"));
        this.fileButton = cf.button(new JIcon("folder-open.png"));
        this.locationRadio = cf.radioButton("info.location.object");
        this.burialPlotRadio = cf.radioButton("info.burialplot.object");
        this.deceasedRadio = cf.radioButton("info.deceased.object", true);
        this.initForm(this.startButton, LAYOUT);
        this.initComponents();
    }

    private void initComponents() {
        this.getRootPane().setDefaultButton(this.startButton);
        this.fileChooser.setFileFilter(new FileNameExtensionFilter("csv", "csv"));
        this.filePath.setEditable(false);
        this.startButton.addActionListener(new ImportAction());
        this.startButton.addKeyListener(new KeyAction());
        this.fileButton.addActionListener(new FileChooserAction());
        this.formatGroup.add(this.defaultRadio);
        this.formatGroup.add(this.excelRadio);
        this.beanGroup.add(this.locationRadio);
        this.beanGroup.add(this.burialPlotRadio);
        this.beanGroup.add(this.deceasedRadio);
        this.charsetGroup.add(this.isoRadio);
        this.charsetGroup.add(this.utf8Radio);
        this.resultsPane.setEditable(false);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(false);
        StyleUtils.addStyles(this.getContext().getComponentFactory(), this.resultsPane.getStyledDocument());
        ValidationComponentUtils.setMessageKey((JComponent)this.filePath, (Object)KEY_FILE);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    protected void buildForm(DefaultFormBuilder builder) {
        CellConstraints cc = new CellConstraints();
        JScrollPane scrollPane = new JScrollPane(this.resultsPane);
        builder.appendI15d("export.file", (Component)this.filePath);
        builder.append((Component)this.fileButton);
        builder.appendI15d("export.type", (Component)this.defaultRadio, 3);
        builder.append("", (Component)this.excelRadio, 3);
        builder.appendI15d("export.charset", (Component)this.utf8Radio, 3);
        builder.append("", (Component)this.isoRadio, 3);
        builder.appendI15d("export.object", (Component)this.deceasedRadio, 3);
        builder.append("", (Component)this.burialPlotRadio, 3);
        if (this.getContext().getSubject().isPermitted("administrate")) {
            builder.append("", (Component)this.locationRadio, 3);
        }
        builder.appendI15d("import.output");
        builder.appendRow(RowSpec.decode((String)"80dlu"));
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 2));
        builder.nextLine(2);
        builder.appendI15d("export.progress", (Component)this.progressBar, 3);
    }

    @Override
    protected void enableButtons(boolean enable) {
        super.enableButtons(enable);
        this.startButton.setEnabled(enable);
        this.progressBar.setIndeterminate(!enable);
    }

    private final class KeyAction
    extends AbstractDialog.KeyAction {
        private KeyAction() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            Object source;
            super.keyPressed(e);
            if (e.getKeyCode() == 10 && (source = e.getSource()).equals(ImportDialog.this.startButton)) {
                ImportDialog.this.startButton.doClick();
            }
        }
    }

    private final class FileChooserAction
    implements ActionListener {
        private FileChooserAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int value = ImportDialog.this.fileChooser.showOpenDialog(ImportDialog.this);
            if (value == 0) {
                String absolutePath = ImportDialog.this.fileChooser.getSelectedFile().getAbsolutePath();
                if (FilenameUtils.getExtension((String)absolutePath).equals("")) {
                    absolutePath = absolutePath.concat(".csv");
                }
                ImportDialog.this.filePath.setText(absolutePath);
                ImportDialog.this.csvFile = new File(absolutePath);
            }
        }
    }

    private final class ImportAction
    implements ActionListener {
        private ImportAction() {
        }

        private ImportTask getImportTask(File file) throws SQLException {
            if (ImportDialog.this.locationRadio.isSelected()) {
                return new LocationImportTask(file);
            }
            if (ImportDialog.this.burialPlotRadio.isSelected()) {
                return new BurialPlotImportTask(file);
            }
            return new DeceasedImportTask(file);
        }

        private String getImportTaskName() {
            if (ImportDialog.this.locationRadio.isSelected()) {
                return "Locations";
            }
            if (ImportDialog.this.burialPlotRadio.isSelected()) {
                return "Burial Plots";
            }
            return "Deceaseds";
        }

        private void execute() {
            ImportDialog.this.enableButtons(false);
            ImportDialog.this.resultsPane.setText("");
            try {
                ImportTask task = this.getImportTask(ImportDialog.this.csvFile);
                task.execute();
            }
            catch (SQLException ex) {
                ImportDialog.this.enableButtons(true);
                throw new SQLRuntimeException(ex);
            }
        }

        private int showConfirmDialog(String messageKey, String messageTitle) {
            return JOptionPane.showConfirmDialog(ImportDialog.this, ImportDialog.this.getContext().getResourceBundle().getString(messageKey), ImportDialog.this.getContext().getResourceBundle().getString(messageTitle), 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int n = this.showConfirmDialog("import.confirm", "import.title");
            if (n == 0) {
                I18nValidationResult result = new I18nValidationResult(ImportDialog.this.getContext().getResourceBundle());
                if (ImportDialog.this.filePath.getText().isEmpty()) {
                    result.addError("import.error.empty_file", ImportDialog.KEY_FILE);
                } else {
                    LOGGER.info((Object)"Importing Data : ".concat(this.getImportTaskName()));
                    this.execute();
                }
                ImportDialog.this.validate(result);
            }
        }
    }

    private final class DeceasedImportTask
    extends ImportTask<Deceased> {
        public DeceasedImportTask(File file) throws SQLException {
            super(file, Deceased.class, "info.deceased.id");
        }

        private Date getDate(ImportTask.I18nCSVRecord record, String key, DateType type) throws CsvParseException {
            switch (type.getId()) {
                default: {
                    return record.getDate(key);
                }
                case 2: {
                    return record.getMonth(key);
                }
                case 3: 
            }
            return record.getYear(key);
        }

        @Override
        protected void populate(Deceased deceased, ImportTask.I18nCSVRecord record) throws SQLException, CsvParseException {
            Integer deathDateTypeId;
            Integer birthDateTypeId;
            Integer burialPlotId;
            deceased.setFirstName(record.getString("info.deceased.first_name"));
            deceased.setNickName(record.getString("info.deceased.nick_name"));
            deceased.setBirthName(record.getString("info.deceased.birth_name"));
            deceased.setLastName(record.getString("info.deceased.last_name"));
            deceased.setComments(record.getString("info.deceased.comments"));
            Integer deceasedTypeId = record.getInt("info.deceased.type_id");
            if (deceasedTypeId != null) {
                DeceasedType deceasedType = new DeceasedType();
                deceasedType.setId(deceasedTypeId);
                deceased.setDeceasedType(deceasedType);
            }
            if ((burialPlotId = record.getInt("info.burialplot.id")) != null) {
                BurialPlot burialPlot = new BurialPlot();
                burialPlot.setId(burialPlotId);
                deceased.setBurialPlot(burialPlot);
            }
            if ((birthDateTypeId = record.getInt("info.deceased.birth_date_type_id")) != null) {
                DateType dateType = new DateType();
                dateType.setId(birthDateTypeId);
                deceased.setBirthDate(this.getDate(record, "info.deceased.birth_date", dateType));
                deceased.setBirthDateType(dateType);
            }
            if ((deathDateTypeId = record.getInt("info.deceased.death_date_type_id")) != null) {
                DateType dateType = new DateType();
                dateType.setId(deathDateTypeId);
                deceased.setDeathDate(this.getDate(record, "info.deceased.death_date", dateType));
                deceased.setDeathDateType(dateType);
            }
        }
    }

    private final class BurialPlotImportTask
    extends ImportTask<BurialPlot> {
        public BurialPlotImportTask(File file) throws SQLException {
            super(file, BurialPlot.class, "info.burialplot.id");
        }

        @Override
        protected void beforeUpdate(BurialPlot bean, ImportTask.I18nCSVRecord record) throws SQLException, CsvParseException {
            this.getValidator().removeExclusions();
            if (bean.getId() == null) {
                return;
            }
            BurialPlot burialPlot = (BurialPlot)this.getDao().queryForId((Object)bean.getId());
            if (burialPlot == null) {
                return;
            }
            String oldRef = burialPlot.getReference();
            String newRef = record.getString("info.burialplot.reference");
            if (newRef != null && newRef.equals(oldRef)) {
                try {
                    this.getValidator().addExclusion("reference", InDatabaseTester.class);
                }
                catch (AnnotationValidatorException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }

        @Override
        protected void populate(BurialPlot burialPlot, ImportTask.I18nCSVRecord record) throws SQLException, CsvParseException {
            Integer locationId;
            burialPlot.setName(record.getString("info.burialplot.name"));
            burialPlot.setReference(record.getString("info.burialplot.reference"));
            burialPlot.setSellDate(record.getDate("info.burialplot.sell_date"));
            burialPlot.setCapacity(record.getInt("info.burialplot.capacity"));
            burialPlot.setDuration(record.getInt("info.burialplot.duration"));
            burialPlot.setComments(record.getString("info.burialplot.comments"));
            Integer burialPlotTypeId = record.getInt("info.burialplot.type_id");
            if (burialPlotTypeId != null) {
                BurialPlotType burialPlotType = new BurialPlotType();
                burialPlotType.setId(burialPlotTypeId);
                burialPlot.setBurialPlotType(burialPlotType);
            }
            if ((locationId = record.getInt("info.location.id")) != null) {
                Location location = new Location();
                location.setId(locationId);
                burialPlot.setLocation(location);
            }
        }
    }

    private final class LocationImportTask
    extends ImportTask<Location> {
        public LocationImportTask(File file) throws SQLException {
            super(file, Location.class, "info.location.id");
        }

        @Override
        protected void beforeUpdate(Location bean, ImportTask.I18nCSVRecord record) throws SQLException, CsvParseException {
            this.getValidator().removeExclusions();
            if (bean.getId() == null) {
                return;
            }
            Location location = (Location)this.getDao().queryForId((Object)bean.getId());
            if (location == null) {
                return;
            }
            String oldRef = location.getReference();
            String newRef = record.getString("info.location.reference");
            if (newRef != null && newRef.equals(oldRef)) {
                try {
                    this.getValidator().addExclusion("reference", InDatabaseTester.class);
                }
                catch (AnnotationValidatorException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }

        @Override
        protected void populate(Location location, ImportTask.I18nCSVRecord record) throws SQLException, CsvParseException {
            location.setReference(record.getString("info.location.reference"));
            location.setDxfHandle(record.getString("info.location.dxf_handle"));
            location.setComments(record.getString("info.location.comments"));
            Integer typeId = record.getInt("info.location.type_id");
            if (typeId != null) {
                LocationType locationType = new LocationType();
                locationType.setId(typeId);
                location.setLocationType(locationType);
            }
        }
    }

    private abstract class ImportTask<K extends AbstractModel>
    extends SwingWorker<I18nResultCount, I18nValidationResult> {
        private final CSVFormat format;
        private final File file;
        private final AnnotationValidator<K> validator;
        private final Class<K> clazz;
        private final Dao<K, Integer> dao;
        private final String stringId;
        private final String charset;

        public ImportTask(File file, Class<K> clazz, String stringId) throws SQLException {
            this.file = file;
            this.clazz = clazz;
            this.stringId = stringId;
            this.dao = ImportDialog.this.getContext().getDaoFactory().getDao(clazz);
            this.format = this.getCSVFormat().withFirstRecordAsHeader().withTrim().withNullString("");
            this.charset = this.getCharset();
            this.validator = new AnnotationValidator<K>(ImportDialog.this.getContext(), clazz);
        }

        private CSVFormat getCSVFormat() {
            CSVFormat csvFormat = CSVFormat.DEFAULT;
            if (ImportDialog.this.excelRadio.isSelected()) {
                csvFormat = CSVFormat.EXCEL;
                if (Locale.getDefault().equals(Locale.FRANCE)) {
                    csvFormat = csvFormat.withDelimiter(';');
                }
            }
            return csvFormat;
        }

        private String getCharset() {
            if (ImportDialog.this.utf8Radio.isSelected()) {
                return "UTF-8";
            }
            return "ISO-8859-1";
        }

        public AnnotationValidator<K> getValidator() {
            return this.validator;
        }

        public Dao<K, Integer> getDao() {
            return this.dao;
        }

        protected abstract void populate(K var1, I18nCSVRecord var2) throws SQLException, CsvParseException;

        protected void beforeCreate(K bean, I18nCSVRecord record) throws SQLException, CsvParseException {
        }

        protected void beforeUpdate(K bean, I18nCSVRecord record) throws SQLException, CsvParseException {
        }

        @Override
        protected I18nResultCount doInBackground() throws Exception {
            int success = 0;
            int errors = 0;
            ResourceBundle resourceBundle = ImportDialog.this.getContext().getResourceBundle();
            try (BufferedReader in = new BufferedReader(FileUtils.newReader(this.file, this.charset));){
                for (CSVRecord record : this.format.parse((Reader)in)) {
                    I18nCSVRecord cr = new I18nCSVRecord(record);
                    I18nValidationResult result = new I18nValidationResult(resourceBundle);
                    AbstractModel bean = (AbstractModel)this.clazz.newInstance();
                    try {
                        bean.setId(cr.getInt(this.stringId));
                        if (bean.getId() == null) {
                            bean.setCreatedAt(new Date());
                            this.beforeCreate(bean, cr);
                        } else {
                            bean.setCreatedAt(cr.getDateTime("info.created_at"));
                            bean.setUpdatedAt(new Date());
                            this.beforeUpdate(bean, cr);
                        }
                        this.populate(bean, cr);
                    }
                    catch (CsvParseException ex) {
                        this.publish(result.addErrorMF("import.error.parsing", ex.getField(), record.getRecordNumber()));
                        ++errors;
                        continue;
                    }
                    ValidationResult validation = this.validator.validate((K)bean);
                    if (validation.hasErrors()) {
                        result.addErrorMF("import.error.validation", record.getRecordNumber());
                        result.addValidationErrors(validation);
                        this.publish(result);
                        ++errors;
                        continue;
                    }
                    ++success;
                    if (bean.getId() == null) {
                        this.dao.create((Object)bean);
                    } else {
                        this.dao.update((Object)bean);
                    }
                    this.publish(result.addInfoMF("import.ok", record.getRecordNumber()));
                }
            }
            return new I18nResultCount(resourceBundle, success, errors);
        }

        private void showError(String key) {
            JOptionPane.showMessageDialog(ImportDialog.this, ImportDialog.this.getContext().getResourceBundle().getString(key), ImportDialog.this.getContext().getResourceBundle().getString("error"), 0);
        }

        @Override
        protected void process(List<I18nValidationResult> chunks) {
            for (I18nValidationResult result : chunks) {
                for (ValidationMessage message : result.getValidationResult()) {
                    StyleUtils.insertMessage(ImportDialog.this.resultsPane.getStyledDocument(), message);
                }
            }
        }

        @Override
        protected void done() {
            block9: {
                try {
                    I18nResultCount resultCount = (I18nResultCount)this.get();
                    StyleUtils.insertInfo(ImportDialog.this.resultsPane.getStyledDocument(), resultCount.getResult());
                    Toolkit.getDefaultToolkit().beep();
                    ImportDialog.this.progressBar.setValue(100);
                    LOGGER.info((Object)"Import results : ".concat(resultCount.getLog()));
                    ImportDialog.this.firePropertyChange(ImportDialog.PROP_END_IMPORT, null, true);
                }
                catch (InterruptedException | ExecutionException ex) {
                    ImportDialog.this.progressBar.setValue(0);
                    if (ex.getCause() instanceof IllegalStateException) {
                        LOGGER.error((Object)("HEADERS ERROR - " + ex.getCause().getMessage()));
                        this.showError("import.error.no_headers");
                        break block9;
                    }
                    if (ex.getCause() instanceof IllegalArgumentException) {
                        LOGGER.error((Object)("FILE ERROR - " + ex.getCause().getMessage()));
                        this.showError("import.error.wrong_file");
                        break block9;
                    }
                    if (ex.getCause() instanceof IOException) {
                        LOGGER.error((Object)("FILE ERROR - " + ex.getCause().getMessage()));
                        this.showError("import.error.wrong_file");
                        break block9;
                    }
                    if (ex.getCause() instanceof SQLException) {
                        throw new SQLRuntimeException((SQLException)ex.getCause());
                    }
                    throw new RuntimeException(ex);
                }
                finally {
                    ImportDialog.this.enableButtons(true);
                }
            }
        }

        protected final class I18nCSVRecord {
            private final CSVRecord record;
            private final ResourceBundle bundle;
            private final DateUtils dateUtils = new DateUtils();

            public I18nCSVRecord(CSVRecord record) {
                this.record = record;
                this.bundle = ImportDialog.this.getContext().getResourceBundle();
            }

            public String getString(String key) {
                return this.record.get(FileUtils.translate(this.bundle, key));
            }

            public Integer getInt(String key) throws CsvParseException {
                String field = this.getString(key);
                try {
                    return field == null ? null : Integer.valueOf(Integer.parseInt(field));
                }
                catch (NumberFormatException ex) {
                    throw new CsvParseException(ex, FileUtils.translate(this.bundle, key));
                }
            }

            public Date getDate(String key) throws CsvParseException {
                String field = this.getString(key);
                try {
                    return this.dateUtils.parseDate(field);
                }
                catch (ParseException ex) {
                    throw new CsvParseException(ex, FileUtils.translate(this.bundle, key));
                }
            }

            public Date getMonth(String key) throws CsvParseException {
                String field = this.getString(key);
                try {
                    return this.dateUtils.parseMonth(field);
                }
                catch (ParseException ex) {
                    throw new CsvParseException(ex, FileUtils.translate(this.bundle, key));
                }
            }

            public Date getYear(String key) throws CsvParseException {
                String field = this.getString(key);
                try {
                    return this.dateUtils.parseYear(field);
                }
                catch (ParseException ex) {
                    throw new CsvParseException(ex, FileUtils.translate(this.bundle, key));
                }
            }

            public Date getDateTime(String key) throws CsvParseException {
                String field = this.getString(key);
                try {
                    return this.dateUtils.parseDateTime(field);
                }
                catch (ParseException ex) {
                    throw new CsvParseException(ex, FileUtils.translate(this.bundle, key));
                }
            }
        }
    }
}

