/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs.menu;

import beans.model.BurialPlot;
import beans.model.Deceased;
import beans.model.Location;
import com.j256.ormlite.dao.Dao;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.validation.view.ValidationComponentUtils;
import context.Context;
import dao.exceptions.SQLRuntimeException;
import gui.components.JIcon;
import gui.components.factory.component.ComponentFactory;
import gui.dialogs.AbstractDialog;
import gui.dialogs.headers.IconHeader;
import gui.dialogs.menu.i18n.I18nValidationResult;
import gui.dialogs.menu.utils.FileUtils;
import gui.utils.DateUtils;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ExportDialog
extends AbstractDialog {
    private final JButton startButton;
    private final JButton fileButton;
    private final JRadioButton locationRadio;
    private final JRadioButton burialPlotRadio;
    private final JRadioButton deceasedRadio;
    private final JTextField filePath = new JTextField();
    private final JRadioButton defaultRadio = new JRadioButton("CSV", true);
    private final JRadioButton excelRadio = new JRadioButton("CSV (Excel)");
    private final JRadioButton isoRadio = new JRadioButton("ISO-8859-1");
    private final JRadioButton utf8Radio = new JRadioButton("UTF-8", true);
    private final ButtonGroup formatGroup = new ButtonGroup();
    private final ButtonGroup beanGroup = new ButtonGroup();
    private final ButtonGroup charsetGroup = new ButtonGroup();
    private final JFileChooser fileChooser = new JFileChooser();
    private final JProgressBar progressBar = new JProgressBar(0, 100);
    private File csvFile = new File("export.csv");
    public static final Log LOGGER = LogFactory.getLog(ExportDialog.class);
    public static final String LAYOUT = "r:p, 4dlu, 170dlu, 4dlu, 40dlu:g";
    public static final String KEY_FILE = "keyFile";
    public static final String PROP_END_EXPORT = "endExport";

    public ExportDialog(Context context) {
        super(context, new IconHeader(context, "export.title", "table-export.png"));
        ComponentFactory cf = context.getComponentFactory();
        this.startButton = cf.button("export.start", new JIcon("export.png"));
        this.fileButton = cf.button(new JIcon("folder-open.png"));
        this.locationRadio = cf.radioButton("info.location.object");
        this.burialPlotRadio = cf.radioButton("info.burialplot.object");
        this.deceasedRadio = cf.radioButton("info.deceased.object", true);
        this.initForm(this.startButton, LAYOUT);
        this.initComponents();
    }

    private void initComponents() {
        this.getRootPane().setDefaultButton(this.startButton);
        this.fileChooser.setFileFilter(new FileNameExtensionFilter("csv", "csv"));
        this.filePath.setEditable(false);
        this.startButton.addActionListener(new ExportAction());
        this.startButton.addKeyListener(new KeyAction());
        this.fileButton.addActionListener(new FileChooserAction());
        this.formatGroup.add(this.defaultRadio);
        this.formatGroup.add(this.excelRadio);
        this.beanGroup.add(this.locationRadio);
        this.beanGroup.add(this.burialPlotRadio);
        this.beanGroup.add(this.deceasedRadio);
        this.charsetGroup.add(this.isoRadio);
        this.charsetGroup.add(this.utf8Radio);
        ValidationComponentUtils.setMessageKey((JComponent)this.filePath, (Object)KEY_FILE);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    protected void buildForm(DefaultFormBuilder builder) {
        builder.appendI15d("export.file", (Component)this.filePath);
        builder.append((Component)this.fileButton);
        builder.appendI15d("export.type", (Component)this.defaultRadio, 3);
        builder.append("", (Component)this.excelRadio, 3);
        builder.appendI15d("export.charset", (Component)this.utf8Radio, 3);
        builder.append("", (Component)this.isoRadio, 3);
        builder.appendI15d("export.object", (Component)this.deceasedRadio, 3);
        builder.append("", (Component)this.burialPlotRadio, 3);
        builder.append("", (Component)this.locationRadio, 3);
        builder.appendI15d("export.progress", (Component)this.progressBar, 3);
    }

    @Override
    protected void enableButtons(boolean enable) {
        super.enableButtons(enable);
        this.startButton.setEnabled(enable);
    }

    private final class KeyAction
    extends AbstractDialog.KeyAction {
        private KeyAction() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            Object source;
            super.keyPressed(e);
            if (e.getKeyCode() == 10 && (source = e.getSource()).equals(ExportDialog.this.startButton)) {
                ExportDialog.this.startButton.doClick();
            }
        }
    }

    private final class FileChooserAction
    implements ActionListener {
        private FileChooserAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int value = ExportDialog.this.fileChooser.showSaveDialog(ExportDialog.this);
            if (value == 0) {
                String absolutePath = ExportDialog.this.fileChooser.getSelectedFile().getAbsolutePath();
                if (FilenameUtils.getExtension((String)absolutePath).equals("")) {
                    absolutePath = absolutePath.concat(".csv");
                }
                ExportDialog.this.filePath.setText(absolutePath);
                ExportDialog.this.csvFile = new File(absolutePath);
            }
        }
    }

    private final class ExportAction
    implements ActionListener {
        private ExportAction() {
        }

        private ExportTask getExportTask(File file) throws SQLException {
            if (ExportDialog.this.locationRadio.isSelected()) {
                return new LocationExportTask(file);
            }
            if (ExportDialog.this.burialPlotRadio.isSelected()) {
                return new BurialPlotExportTask(file);
            }
            return new DeceasedExportTask(file);
        }

        private String getExportTaskName() {
            if (ExportDialog.this.locationRadio.isSelected()) {
                return "Locations";
            }
            if (ExportDialog.this.burialPlotRadio.isSelected()) {
                return "Burial Plots";
            }
            return "Deceaseds";
        }

        private void execute() {
            ExportDialog.this.enableButtons(false);
            try {
                ExportTask task = this.getExportTask(ExportDialog.this.csvFile);
                task.addPropertyChangeListener(new ProgressListener(ExportDialog.this.progressBar));
                task.execute();
            }
            catch (SQLException ex) {
                ExportDialog.this.enableButtons(true);
                throw new SQLRuntimeException(ex);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            I18nValidationResult result = new I18nValidationResult(ExportDialog.this.getContext().getResourceBundle());
            if (ExportDialog.this.filePath.getText().isEmpty()) {
                result.addError("export.error.empty_file", ExportDialog.KEY_FILE);
            } else {
                LOGGER.info((Object)"Exporting Data : ".concat(this.getExportTaskName()));
                this.execute();
            }
            ExportDialog.this.validate(result);
        }
    }

    public static final class ProgressListener
    implements PropertyChangeListener {
        private final JProgressBar bar;

        public ProgressListener(JProgressBar bar) {
            this.bar = bar;
            this.bar.setValue(0);
            this.bar.setStringPainted(true);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("progress")) {
                this.bar.setValue((Integer)evt.getNewValue());
            }
        }
    }

    private final class DeceasedExportTask
    extends ExportTask<Deceased> {
        private final String[] fields;

        public DeceasedExportTask(File file) throws SQLException {
            super(file, Deceased.class);
            this.fields = new String[]{"info.deceased.id", "info.deceased.first_name", "info.deceased.nick_name", "info.deceased.birth_name", "info.deceased.last_name", "info.deceased.birth_date", "info.deceased.birth_date_type_id", "info.deceased.birth_date_type", "info.deceased.death_date", "info.deceased.death_date_type_id", "info.deceased.death_date_type", "info.deceased.comments", "info.deceased.type_id", "info.deceased.type", "info.burialplot.id"};
            this.addToHeader(this.fields);
        }

        @Override
        protected int print(CSVPrinter printer) throws SQLException, IOException {
            int index = 0;
            for (Deceased deceased : this.findAll()) {
                printer.printRecord(new Object[]{deceased.getId(), deceased.getFirstName(), deceased.getNickName(), deceased.getBirthName(), deceased.getLastName(), this.getDateUtils().formatVarDate(deceased.getBirthDateType(), deceased.getBirthDate()), deceased.getBirthDateType().getId(), deceased.getBirthDateType().getLib(), this.getDateUtils().formatVarDate(deceased.getDeathDateType(), deceased.getDeathDate()), deceased.getDeathDateType().getId(), deceased.getDeathDateType().getLib(), deceased.getComments(), deceased.getDeceasedType().getId(), deceased.getDeceasedType().getLib(), deceased.getBurialPlot().getId(), this.getDateUtils().formatDateTime(deceased.getCreatedAt()), this.getDateUtils().formatDateTime(deceased.getUpdatedAt())});
                this.setProgress(this.getPercentage(++index));
            }
            return index;
        }
    }

    private final class BurialPlotExportTask
    extends ExportTask<BurialPlot> {
        protected final String[] fields;

        public BurialPlotExportTask(File file) throws SQLException {
            super(file, BurialPlot.class);
            this.fields = new String[]{"info.burialplot.id", "info.burialplot.name", "info.burialplot.reference", "info.burialplot.capacity", "info.burialplot.sell_date", "info.burialplot.duration", "info.burialplot.comments", "info.burialplot.type_id", "info.burialplot.type", "info.location.id"};
            this.addToHeader(this.fields);
        }

        @Override
        protected int print(CSVPrinter printer) throws SQLException, IOException {
            int index = 0;
            for (BurialPlot burialPlot : this.findAll()) {
                printer.printRecord(new Object[]{burialPlot.getId(), burialPlot.getName(), burialPlot.getReference(), burialPlot.getCapacity(), this.getDateUtils().formatDate(burialPlot.getSellDate()), burialPlot.getDuration(), burialPlot.getComments(), burialPlot.getBurialPlotType().getId(), burialPlot.getBurialPlotType().getLib(), burialPlot.getLocation().getId(), this.getDateUtils().formatDateTime(burialPlot.getCreatedAt()), this.getDateUtils().formatDateTime(burialPlot.getUpdatedAt())});
                this.setProgress(this.getPercentage(++index));
            }
            return index;
        }
    }

    private final class LocationExportTask
    extends ExportTask<Location> {
        private final String[] fields;

        public LocationExportTask(File file) throws SQLException {
            super(file, Location.class);
            this.fields = new String[]{"info.location.id", "info.location.reference", "info.location.dxf_handle", "info.location.comments", "info.location.type_id", "info.location.type"};
            this.addToHeader(this.fields);
        }

        @Override
        protected int print(CSVPrinter printer) throws SQLException, IOException {
            int index = 0;
            for (Location location : this.findAll()) {
                printer.printRecord(new Object[]{location.getId(), location.getReference(), location.getDxfHandle(), location.getComments(), location.getLocationType().getId(), location.getLocationType().getLib(), this.getDateUtils().formatDateTime(location.getCreatedAt()), this.getDateUtils().formatDateTime(location.getUpdatedAt())});
                this.setProgress(this.getPercentage(++index));
            }
            return index;
        }
    }

    private abstract class ExportTask<K>
    extends SwingWorker<Integer, Void> {
        private final CSVFormat format;
        private final File file;
        private final Dao<K, Integer> dao;
        private final long count;
        private final String charset;
        private final DateUtils dateUtils = new DateUtils();
        private String[] header = new String[]{"info.created_at", "info.updated_at"};

        public ExportTask(File file, Class<K> clazz) throws SQLException {
            this.file = file;
            this.format = this.getCSVFormat();
            this.dao = ExportDialog.this.getContext().getDaoFactory().getDao(clazz);
            this.charset = this.getCharset();
            this.count = this.dao.countOf();
        }

        public DateUtils getDateUtils() {
            return this.dateUtils;
        }

        private CSVFormat getCSVFormat() {
            CSVFormat csvFormat = CSVFormat.DEFAULT;
            if (ExportDialog.this.excelRadio.isSelected()) {
                csvFormat = CSVFormat.EXCEL;
                if (ExportDialog.this.getContext().getResourceBundle().getLocale().equals(Locale.FRENCH)) {
                    csvFormat = csvFormat.withDelimiter(';');
                }
            }
            return csvFormat;
        }

        private String getCharset() {
            if (ExportDialog.this.utf8Radio.isSelected()) {
                return "UTF-8";
            }
            return "ISO-8859-1";
        }

        protected abstract int print(CSVPrinter var1) throws SQLException, IOException;

        protected int getPercentage(int index) throws SQLException {
            return Math.round((float)index * 100.0f / (float)this.count);
        }

        protected void addToHeader(String[] fields) {
            this.header = (String[])ArrayUtils.addAll((Object[])fields, (Object[])this.header);
        }

        protected List<K> findAll() throws SQLException {
            return this.dao.queryBuilder().orderBy("ID", true).query();
        }

        @Override
        protected Integer doInBackground() throws Exception {
            int resultCount;
            try (BufferedWriter out = new BufferedWriter(FileUtils.newWriter(this.file, this.charset));){
                String[] translated = FileUtils.translate(ExportDialog.this.getContext().getResourceBundle(), this.header);
                CSVPrinter printer = new CSVPrinter((Appendable)out, this.format.withHeader(translated));
                this.setProgress(0);
                resultCount = this.print(printer);
                printer.flush();
            }
            return resultCount;
        }

        @Override
        protected void done() {
            try {
                int resultCount = (Integer)this.get();
                Toolkit.getDefaultToolkit().beep();
                LOGGER.info((Object)("Export Results : " + resultCount));
                ExportDialog.this.firePropertyChange(ExportDialog.PROP_END_EXPORT, null, true);
            }
            catch (InterruptedException | ExecutionException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                ExportDialog.this.enableButtons(true);
            }
        }
    }
}

