/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs.menu;

import beans.model.BurialPlotType;
import beans.model.DeceasedType;
import beans.search.BurialPlotSO;
import beans.search.DeceasedSO;
import context.Context;
import dao.exceptions.SQLRuntimeException;
import gui.components.JIcon;
import gui.components.JTabbedDialog;
import gui.dialogs.forms.beans.search.AbstractSearchForm;
import gui.dialogs.forms.beans.search.BurialPlotSearchForm;
import gui.dialogs.forms.beans.search.DeceasedSearchForm;
import java.awt.Frame;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;

public final class AdvSearchDialog
extends JTabbedDialog<AbstractSearchForm> {
    private final Context context;

    public AdvSearchDialog(Context context) {
        super((Frame)context.getMainFrame(), context.getResourceBundle().getString("search.search"));
        this.context = context;
        this.initComponents();
    }

    public void addTab(String title, String icon, AbstractSearchForm component) {
        super.addTab(this.context.getResourceBundle().getString(title), this.context.getComponentFactory().imageIcon(new JIcon(icon)), component);
    }

    private void initComponents() {
        try {
            this.addTab("info.burialplot.object", "headstone.png", this.getBurialPlotSearchForm());
            this.addTab("info.deceased.object", "user.png", this.getDeceasedSearchForm());
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
        this.setDefaultButton(((AbstractSearchForm)this.getSelectedTab()).getSearchButton());
        this.addChangeListener(e -> {
            this.reset();
            AbstractSearchForm formTabVisible = (AbstractSearchForm)this.getSelectedTab();
            formTabVisible.getRootPane().setDefaultButton(formTabVisible.getSearchButton());
        });
        this.addAllPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("closeDialog")) {
                this.dispose();
            }
        });
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public void reset() {
        this.loopOnTabs(t -> {
            t.resetAction();
            return true;
        });
    }

    public void addAllPropertyChangeListener(PropertyChangeListener listener) {
        this.loopOnTabs(t -> {
            t.addPropertyChangeListener(listener);
            return true;
        });
    }

    private AbstractSearchForm getDeceasedSearchForm() throws SQLException {
        DeceasedSO deceasedSO = new DeceasedSO();
        DeceasedType first = (DeceasedType)this.context.getDaoFactory().getDeceasedTypeDAO().queryForId(1);
        deceasedSO.setDeceasedType(first);
        return new DeceasedSearchForm(this.context, deceasedSO);
    }

    private AbstractSearchForm getBurialPlotSearchForm() throws SQLException {
        BurialPlotSO burialPlotSO = new BurialPlotSO();
        BurialPlotType first = (BurialPlotType)this.context.getDaoFactory().getBurialPlotTypeDAO().queryForId(1);
        burialPlotSO.setBurialPlotType(first);
        return new BurialPlotSearchForm(this.context, burialPlotSO);
    }
}

