/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs.menu;

import context.Context;
import gui.components.JIcon;
import gui.components.JImage;
import gui.components.factory.component.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public final class AboutDialog
extends JDialog {
    private final JButton closeButton;
    private final JLabel logo;
    private final JLabel version;
    private final JLabel author;
    private final JLabel phone;
    private final JLabel web;
    private final JLabel email;
    private final JLabel icons;
    private final JLabel space = new JLabel("    ");
    private final ComponentFactory componentFactory;

    public AboutDialog(Context context) {
        super(context.getMainFrame(), context.getResourceBundle().getString("menu.cim.about"), true);
        this.componentFactory = context.getComponentFactory();
        this.closeButton = this.componentFactory.button("dialog.close", new JIcon("cross.png"));
        this.logo = this.componentFactory.label(new JImage("logo-about.png"));
        this.author = this.componentFactory.label("about.author");
        this.phone = this.componentFactory.label("about.phone");
        this.web = this.componentFactory.label("about.web");
        this.email = this.componentFactory.label("about.email");
        this.icons = this.componentFactory.label("about.icons");
        this.version = new JLabel(context.getConfiguration().getString("version"));
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel logoPanel = new JPanel();
        logoPanel.setBackground(Color.WHITE);
        logoPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
        logoPanel.add(this.logo);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BoxLayout(infoPanel, 1));
        this.logo.setBorder(BorderFactory.createEmptyBorder(20, 50, 20, 50));
        this.logo.setAlignmentX(0.5f);
        this.version.setAlignmentX(0.5f);
        this.author.setAlignmentX(0.5f);
        this.phone.setAlignmentX(0.5f);
        this.web.setAlignmentX(0.5f);
        this.email.setAlignmentX(0.5f);
        this.icons.setAlignmentX(0.5f);
        this.version.setBorder(new EmptyBorder(20, 0, 0, 0));
        this.icons.setBorder(new EmptyBorder(0, 0, 20, 0));
        this.space.setAlignmentX(0.5f);
        this.closeButton.addActionListener(new CloseAction());
        this.closeButton.addKeyListener(new KeyAction());
        this.closeButton.setAlignmentX(0.5f);
        infoPanel.add(this.version);
        infoPanel.add(this.author);
        infoPanel.add(this.phone);
        infoPanel.add(this.web);
        infoPanel.add(this.email);
        infoPanel.add(this.icons);
        infoPanel.add(this.closeButton);
        infoPanel.add(this.space);
        this.add((Component)logoPanel, "First");
        this.add((Component)infoPanel, "Center");
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AboutDialog.this.closeButton.doClick();
            }
        });
    }

    private class KeyAction
    implements KeyListener {
        private KeyAction() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            Object source;
            if (e.getKeyCode() == 10 && (source = e.getSource()).equals(AboutDialog.this.closeButton)) {
                AboutDialog.this.closeButton.doClick();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private final class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AboutDialog.this.dispose();
        }
    }
}

