/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs.forms.beans.validators.testers;

import beans.model.AbstractModel;
import com.j256.ormlite.dao.Dao;
import dao.DaoFactory;
import dao.exceptions.SQLRuntimeException;
import gui.dialogs.forms.beans.validators.annotations.InDatabase;
import gui.dialogs.forms.beans.validators.testers.AbstractTester;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ResourceBundle;

public final class InDatabaseTester<T extends AbstractModel>
extends AbstractTester<T> {
    private final InDatabase annotation;
    private final DaoFactory daoFactory;

    public InDatabaseTester(ResourceBundle bundle, DaoFactory daoFactory, Class clazz, Field field) throws SQLException {
        super(bundle, clazz, field);
        this.annotation = field.getAnnotation(InDatabase.class);
        this.daoFactory = daoFactory;
    }

    private Dao getDao() throws SQLException {
        Class<?> clazz = this.annotation.foreign() ? this.getField().getType() : this.getClazz();
        return this.daoFactory.getDao(clazz);
    }

    private Object getValue(Object value) {
        return this.annotation.foreign() ? ((AbstractModel)value).getId() : value;
    }

    private boolean check(Object value) {
        try {
            return this.getDao().queryBuilder().where().eq(this.annotation.column(), this.getValue(value)).countOf() == 0L;
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    @Override
    protected String getMessage() {
        return this.getBundle().getString(this.annotation.messageKey());
    }

    @Override
    protected boolean hasError(Object value) {
        if (value == null) {
            return false;
        }
        return this.annotation.not() ^ this.check(value);
    }
}

