/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs.forms.beans.validators.testers;

import beans.model.AbstractModel;
import gui.dialogs.forms.beans.validators.annotations.BoundedValue;
import gui.dialogs.forms.beans.validators.testers.AbstractTester;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public final class BoundedValueTester<T extends AbstractModel>
extends AbstractTester<T> {
    private final BoundedValue annotation;

    private static boolean check(int value, int min, int max) {
        return value < min || value > max;
    }

    public BoundedValueTester(ResourceBundle bundle, Class clazz, Field field) {
        super(bundle, clazz, field);
        this.annotation = field.getAnnotation(BoundedValue.class);
    }

    @Override
    protected String getMessage() {
        return MessageFormat.format(this.getBundle().getString(this.annotation.messageKey()), this.annotation.min(), this.annotation.max());
    }

    @Override
    protected boolean hasError(Object value) {
        if (value == null) {
            return false;
        }
        return BoundedValueTester.check((Integer)value, this.annotation.min(), this.annotation.max());
    }
}

