/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs.forms.beans.validators.testers;

import beans.model.AbstractModel;
import com.jgoodies.validation.ValidationResult;
import gui.dialogs.forms.beans.validators.exceptions.AnnotationTesterException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.apache.commons.beanutils.PropertyUtils;

public abstract class AbstractTester<T extends AbstractModel> {
    private final ResourceBundle resourceBundle;
    private final Class clazz;
    private final Field field;

    public AbstractTester(ResourceBundle resourceBundle, Class clazz, Field field) {
        this.resourceBundle = resourceBundle;
        this.clazz = clazz;
        this.field = field;
    }

    protected abstract String getMessage();

    protected abstract boolean hasError(Object var1);

    public ValidationResult test(T bean) throws AnnotationTesterException {
        ValidationResult result = new ValidationResult();
        try {
            if (this.hasError(PropertyUtils.getSimpleProperty(bean, (String)this.field.getName()))) {
                result.addError(this.getMessage(), (Object)this.field.getName());
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new AnnotationTesterException(ex);
        }
        return result;
    }

    public Field getField() {
        return this.field;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public ResourceBundle getBundle() {
        return this.resourceBundle;
    }
}

