/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs.forms.beans.validators;

import beans.model.AbstractModel;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.Validator;
import context.Context;
import dao.DaoFactory;
import gui.dialogs.forms.beans.validators.annotations.BoundedLenght;
import gui.dialogs.forms.beans.validators.annotations.BoundedValue;
import gui.dialogs.forms.beans.validators.annotations.InDatabase;
import gui.dialogs.forms.beans.validators.annotations.NotBlank;
import gui.dialogs.forms.beans.validators.annotations.NotNull;
import gui.dialogs.forms.beans.validators.exceptions.AnnotationTesterException;
import gui.dialogs.forms.beans.validators.exceptions.AnnotationValidatorException;
import gui.dialogs.forms.beans.validators.testers.AbstractTester;
import gui.dialogs.forms.beans.validators.testers.BoundedLenghtTester;
import gui.dialogs.forms.beans.validators.testers.BoundedValueTester;
import gui.dialogs.forms.beans.validators.testers.InDatabaseTester;
import gui.dialogs.forms.beans.validators.testers.NotBlankTester;
import gui.dialogs.forms.beans.validators.testers.NotNullTester;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public final class AnnotationValidator<T extends AbstractModel>
implements Validator<T> {
    private final Context context;
    private final Class<T> clazz;
    private final List<Field> fields;
    private final Map<Field, List<AbstractTester>> testers = new HashMap<Field, List<AbstractTester>>();
    private final Map<Field, List<Class>> exclusions = new HashMap<Field, List<Class>>();

    public AnnotationValidator(Context context, Class<T> clazz) throws SQLException {
        this.context = context;
        this.clazz = clazz;
        this.fields = AnnotationValidator.getAllFields(clazz);
        this.init();
    }

    public void removeExclusions() {
        this.exclusions.clear();
    }

    public void addExclusion(String field, Class ... classes) throws AnnotationValidatorException {
        try {
            Field declaredField = this.clazz.getDeclaredField(field);
            if (!this.exclusions.containsKey(declaredField)) {
                this.exclusions.put(declaredField, Arrays.asList(classes));
            }
        }
        catch (NoSuchFieldException | SecurityException ex) {
            throw new AnnotationValidatorException(ex);
        }
    }

    public boolean hasExclusion(Field field, Class clazz) {
        return this.exclusions.containsKey(field) && this.exclusions.get(field).contains(clazz);
    }

    public static List<Field> getAllFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            fields.addAll(Arrays.asList(c.getDeclaredFields()));
        }
        return fields;
    }

    private void init() throws SQLException {
        ResourceBundle rb = this.context.getResourceBundle();
        DaoFactory df = this.context.getDaoFactory();
        for (Field field : this.fields) {
            ArrayList<AbstractTester> list = new ArrayList<AbstractTester>();
            if (field.isAnnotationPresent(NotNull.class)) {
                list.add(new NotNullTester(rb, this.clazz, field));
            }
            if (field.isAnnotationPresent(NotBlank.class)) {
                list.add(new NotBlankTester(rb, this.clazz, field));
            }
            if (field.isAnnotationPresent(BoundedLenght.class)) {
                list.add(new BoundedLenghtTester(rb, this.clazz, field));
            }
            if (field.isAnnotationPresent(BoundedValue.class)) {
                list.add(new BoundedValueTester(rb, this.clazz, field));
            }
            if (field.isAnnotationPresent(InDatabase.class)) {
                list.add(new InDatabaseTester(rb, df, this.clazz, field));
            }
            this.testers.put(field, list);
        }
    }

    private ValidationResult validate(Field field, T bean) throws AnnotationTesterException {
        ValidationResult result = new ValidationResult();
        for (AbstractTester tester : this.testers.get(field)) {
            if (this.hasExclusion(field, tester.getClass())) continue;
            result.addAllFrom(tester.test(bean));
        }
        return result;
    }

    public ValidationResult validate(T bean) {
        ValidationResult result = new ValidationResult();
        for (Field field : this.fields) {
            try {
                result.addAllFrom(this.validate(field, bean));
            }
            catch (AnnotationTesterException ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }
}

