/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs.forms.beans.search;

import beans.model.DeceasedType;
import beans.search.DeceasedSO;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import context.Context;
import dao.exceptions.SQLRuntimeException;
import gui.components.factory.form.FormFactory;
import gui.dialogs.forms.beans.search.AbstractSearchForm;
import java.awt.Component;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jdesktop.xswingx.PromptSupport;

public final class DeceasedSearchForm
extends AbstractSearchForm<DeceasedSO> {
    private final JTextField firstNameField;
    private final JTextField lastNameField;
    private final JTextField birthNameField;
    private final JTextField nickNameField;
    private final JTextArea commentsArea;
    private final JComboBox deceasedTypeBox;
    private final JSpinner birthDateStartSpinner;
    private final JSpinner birthDateEndSpinner;
    private final JSpinner deathDateStartSpinner;
    private final JSpinner deathDateEndSpinner;
    private final JCheckBox birthDateStartNullBox;
    private final JCheckBox birthDateEndNullBox;
    private final JCheckBox deathDateStartNullBox;
    private final JCheckBox deathDateEndNullBox;
    private final JCheckBox withFirstName;
    private final JCheckBox withLastName;
    private final JCheckBox withBirthName;
    private final JCheckBox withNickName;
    private final JCheckBox withComments;
    private final JCheckBox withDeceasedType;
    private final JCheckBox withBirthDate;
    private final JCheckBox withDeathDate;
    public static final String PROP_SEARCH_DECEASED = "searchDeceased";

    public DeceasedSearchForm(Context context, DeceasedSO deceasedSO) throws SQLException {
        super(context, "search.deceased.title", deceasedSO);
        FormFactory ff = this.getFormFactory();
        this.firstNameField = ff.textField("firstName");
        this.lastNameField = ff.textField("lastName");
        this.birthNameField = ff.textField("birthName");
        this.nickNameField = ff.textField("nickName");
        this.commentsArea = ff.textArea("comments");
        this.deceasedTypeBox = ff.beanComboBox("deceasedType", this.getDeceasedTypes());
        this.birthDateStartSpinner = ff.dateSpinner("birthDateStart", DeceasedSO.PAR_BIRTH_DATE_START);
        this.birthDateEndSpinner = ff.dateSpinner("birthDateEnd", DeceasedSO.PAR_BIRTH_DATE_END);
        this.deathDateStartSpinner = ff.dateSpinner("deathDateStart", DeceasedSO.PAR_DEATH_DATE_START);
        this.deathDateEndSpinner = ff.dateSpinner("deathDateEnd", DeceasedSO.PAR_DEATH_DATE_END);
        this.birthDateStartNullBox = ff.nullDateCheckBox("birthDateStart", this.birthDateStartSpinner);
        this.birthDateEndNullBox = ff.nullDateCheckBox("birthDateEnd", this.birthDateEndSpinner);
        this.deathDateStartNullBox = ff.nullDateCheckBox("deathDateStart", this.deathDateStartSpinner);
        this.deathDateEndNullBox = ff.nullDateCheckBox("deathDateEnd", this.deathDateEndSpinner);
        this.withFirstName = ff.checkBox("withFirstName");
        this.withLastName = ff.checkBox("withLastName");
        this.withBirthName = ff.checkBox("withBirthName");
        this.withNickName = ff.checkBox("withNickName");
        this.withComments = ff.checkBox("withComments");
        this.withDeceasedType = ff.checkBox("withDeceasedType");
        this.withBirthDate = ff.checkBox("withBirthDate");
        this.withDeathDate = ff.checkBox("withDeathDate");
        this.initForm();
        this.initComponents();
    }

    private List<DeceasedType> getDeceasedTypes() throws SQLException {
        return this.getContext().getDaoFactory().getDeceasedTypeDAO().queryForAll();
    }

    private void initComponents() throws SQLException {
        this.commentsArea.setRows(10);
        this.commentsArea.setLineWrap(true);
        this.commentsArea.setWrapStyleWord(true);
        String unknown = this.getContext().getResourceBundle().getString("info.bean.unknown");
        PromptSupport.setPrompt((String)unknown, (JTextComponent)this.firstNameField);
        PromptSupport.setPrompt((String)unknown, (JTextComponent)this.lastNameField);
        PromptSupport.setPrompt((String)unknown, (JTextComponent)this.birthNameField);
        PromptSupport.setPrompt((String)unknown, (JTextComponent)this.nickNameField);
        String format = "dd/MM/yyyy";
        this.birthDateStartSpinner.setEditor(new JSpinner.DateEditor(this.birthDateStartSpinner, format));
        this.birthDateEndSpinner.setEditor(new JSpinner.DateEditor(this.birthDateEndSpinner, format));
        this.deathDateStartSpinner.setEditor(new JSpinner.DateEditor(this.deathDateStartSpinner, format));
        this.deathDateEndSpinner.setEditor(new JSpinner.DateEditor(this.deathDateEndSpinner, format));
    }

    @Override
    protected void buildForm(DefaultFormBuilder builder) {
        builder.appendI15d("search.deceased.first_name", (Component)this.withFirstName, (Component)this.firstNameField, 9);
        builder.appendI15d("search.deceased.last_name", (Component)this.withLastName, (Component)this.lastNameField, 9);
        builder.appendI15d("search.deceased.birth_name", (Component)this.withBirthName, (Component)this.birthNameField, 9);
        builder.appendI15d("search.deceased.nick_name", (Component)this.withNickName, (Component)this.nickNameField, 9);
        builder.appendI15d("search.deceased.type", (Component)this.withDeceasedType, (Component)this.deceasedTypeBox, 9);
        builder.appendI15d("search.deceased.birth_date", (Component)this.withBirthDate, (Component)this.birthDateStartSpinner);
        builder.append((Component)this.birthDateStartNullBox);
        builder.appendI15d("search.and", (Component)this.birthDateEndSpinner, (Component)this.birthDateEndNullBox);
        builder.appendI15d("search.deceased.death_date", (Component)this.withDeathDate, (Component)this.deathDateStartSpinner);
        builder.append((Component)this.deathDateStartNullBox);
        builder.appendI15d("search.and", (Component)this.deathDateEndSpinner, (Component)this.deathDateEndNullBox);
        builder.appendI15d("search.deceased.comments", (Component)this.withComments, (Component)new JScrollPane(this.commentsArea), 9);
    }

    @Override
    public void searchAction() {
        this.firePropertyChange(PROP_SEARCH_DECEASED, null, this.getBean());
    }

    @Override
    public void resetAction() {
        try {
            DeceasedSO deceasedSO = new DeceasedSO();
            DeceasedType first = (DeceasedType)this.getContext().getDaoFactory().getDeceasedTypeDAO().queryForId(1);
            deceasedSO.setDeceasedType(first);
            this.setBean(deceasedSO);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }
}

