/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs.forms.beans.search;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import context.Context;
import gui.components.JIcon;
import gui.components.factory.component.ComponentFactory;
import gui.dialogs.AbstractDialog;
import gui.dialogs.forms.beans.search.AbstractForm;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public abstract class AbstractSearchForm<T>
extends AbstractForm<T> {
    private final JButton searchButton;
    private final JButton resetButton;
    private final JButton closeButton;
    private final JPanel formPanel = new JPanel();
    public static final String PROP_CLOSE_DIALOG = "closeDialog";

    public AbstractSearchForm(Context context, String title, T bean) {
        super(context, title, bean);
        ComponentFactory cf = context.getComponentFactory();
        this.searchButton = cf.button("search.search", new JIcon("search.png"));
        this.resetButton = cf.button("search.reset", new JIcon("reset.png"));
        this.closeButton = cf.button("search.close", new JIcon("cross.png"));
        this.initComponents();
    }

    private void initComponents() {
        this.add(this.formPanel);
        KeyAction keyAction = new KeyAction();
        this.searchButton.addKeyListener(keyAction);
        this.resetButton.addKeyListener(keyAction);
        this.closeButton.addKeyListener(keyAction);
        ButtonListener listener = new ButtonListener();
        this.searchButton.addActionListener(listener);
        this.resetButton.addActionListener(listener);
        this.closeButton.addActionListener(listener);
    }

    protected final void initForm() {
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("r:100dlu:g, 4dlu, 25dlu:g, 4dlu, 60dlu:g, 4dlu, 50dlu, 4dlu, r:p, 4dlu, 60dlu, 4dlu, 50dlu:g"), this.getContext().getResourceBundle(), this.formPanel);
        builder.padding((EmptyBorder)Paddings.DIALOG);
        builder.appendSeparator(this.getTitle());
        builder.defaultRowSpec(RowSpec.decode((String)"t:p"));
        this.buildForm(builder);
        builder.appendRow("7dlu");
        builder.appendRow("pref");
        builder.add((Component)this.buildButtonBar(), AbstractDialog.rightFullCC(builder));
        builder.build();
    }

    protected abstract void buildForm(DefaultFormBuilder var1);

    private JPanel buildButtonBar() {
        ButtonBarBuilder builder = new ButtonBarBuilder().addButton((JComponent)this.searchButton).addRelatedGap().addButton((JComponent)this.resetButton).addRelatedGap().addButton((JComponent)this.closeButton);
        return builder.build();
    }

    public final JButton getSearchButton() {
        return this.searchButton;
    }

    public abstract void searchAction();

    public abstract void resetAction();

    private final class KeyAction
    implements KeyListener {
        private KeyAction() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                Object source = e.getSource();
                if (source.equals(AbstractSearchForm.this.searchButton)) {
                    AbstractSearchForm.this.searchButton.doClick();
                } else if (source.equals(AbstractSearchForm.this.resetButton)) {
                    AbstractSearchForm.this.resetButton.doClick();
                } else if (source.equals(AbstractSearchForm.this.closeButton)) {
                    AbstractSearchForm.this.closeButton.doClick();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private final class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton source = (JButton)e.getSource();
            if (source.equals(AbstractSearchForm.this.searchButton)) {
                AbstractSearchForm.this.setCursor(Cursor.getPredefinedCursor(3));
                AbstractSearchForm.this.searchAction();
                AbstractSearchForm.this.setCursor(null);
            } else if (source.equals(AbstractSearchForm.this.resetButton)) {
                AbstractSearchForm.this.resetAction();
            } else if (source.equals(AbstractSearchForm.this.closeButton)) {
                AbstractSearchForm.this.firePropertyChange(AbstractSearchForm.PROP_CLOSE_DIALOG, null, true);
            }
        }
    }
}

