/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs.forms.beans.model;

import beans.model.Location;
import beans.model.LocationType;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.validation.view.ValidationComponentUtils;
import context.Context;
import dao.exceptions.SQLRuntimeException;
import gui.components.factory.form.FormFactory;
import gui.dialogs.forms.beans.model.AbstractModelForm;
import gui.dialogs.forms.beans.validators.exceptions.AnnotationValidatorException;
import gui.dialogs.forms.beans.validators.testers.InDatabaseTester;
import gui.dialogs.headers.IconHeader;
import java.awt.Component;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public final class LocationForm
extends AbstractModelForm<Location> {
    private final JComboBox locationTypesBox;
    private final JTextField dxfHandleField;
    private final JTextField referenceField;
    private final JTextArea commentsArea;
    private final String originalRef;
    public static final String PROP_LOCATION_POST_SAVE = "locationPostSave";
    public static final String PROP_LOCATION_POST_DELETE = "locationPostDelete";

    public LocationForm(Context context, String title, Location location) throws SQLException {
        super(context, new IconHeader(context, title, "marker.png"), Location.class, location);
        this.originalRef = location.getReference();
        FormFactory ff = this.getFormFactory();
        this.locationTypesBox = ff.beanComboBox("locationType", this.getLocationTypes());
        this.dxfHandleField = ff.textField("dxfHandle");
        this.referenceField = ff.textField("reference");
        this.commentsArea = ff.textArea("comments");
        this.initForm();
        this.initComponents();
    }

    private List<LocationType> getLocationTypes() throws SQLException {
        return this.getContext().getDaoFactory().getLocationTypeDAO().queryForAll();
    }

    private void initComponents() throws SQLException {
        this.commentsArea.setRows(10);
        this.commentsArea.setLineWrap(true);
        this.commentsArea.setWrapStyleWord(true);
        ValidationComponentUtils.setMessageKey((JComponent)this.referenceField, (Object)"reference");
        ValidationComponentUtils.setMessageKey((JComponent)this.dxfHandleField, (Object)"dxfHandle");
        ValidationComponentUtils.setMessageKey((JComponent)this.commentsArea, (Object)"comments");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    protected void buildForm(DefaultFormBuilder builder) {
        super.buildForm(builder);
        builder.appendI15d("form.location.reference", (Component)this.referenceField, 5);
        builder.appendI15d("form.location.dxfhandle", (Component)this.dxfHandleField, 5);
        builder.appendI15d("form.location.type", (Component)this.locationTypesBox, 5);
        builder.appendI15d("form.burialplot.comments", (Component)new JScrollPane(this.commentsArea), 5);
    }

    @Override
    protected void postSave() {
        this.firePropertyChange(PROP_LOCATION_POST_SAVE, null, this.getBean());
        this.dispose();
    }

    @Override
    protected void preValidate() {
        String reference = ((Location)this.getBean()).getReference();
        if (reference != null && reference.equals(this.originalRef)) {
            try {
                this.getValidator().addExclusion("reference", InDatabaseTester.class);
            }
            catch (AnnotationValidatorException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    protected boolean preDelete() {
        try {
            long count = this.getContext().getDaoFactory().getBurialPlotDAO().countBy((Location)this.getBean());
            if (count > 0L) {
                JOptionPane.showMessageDialog(this, this.getContext().getResourceBundle().getString("form.location.error"), this.getContext().getResourceBundle().getString("form.error"), 0);
                return false;
            }
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
        return true;
    }

    @Override
    protected void postDelete() {
        this.firePropertyChange(PROP_LOCATION_POST_DELETE, null, this.getBean());
        this.dispose();
    }
}

