/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs.forms.beans.model;

import beans.model.BurialPlot;
import beans.model.DateType;
import beans.model.Deceased;
import beans.model.DeceasedType;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.validation.view.ValidationComponentUtils;
import context.Context;
import gui.components.factory.form.FormFactory;
import gui.dialogs.forms.beans.model.AbstractModelForm;
import gui.dialogs.headers.IconHeader;
import java.awt.Component;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import org.jdesktop.xswingx.PromptSupport;

public final class DeceasedForm
extends AbstractModelForm<Deceased> {
    private final JComboBox burialPlotBox;
    private final JComboBox deceasedTypeBox;
    private final JTextField firstNameField;
    private final JTextField birthNameField;
    private final JTextField nickNameField;
    private final JTextField lastNameField;
    private final JSpinner birthDateSpinner;
    private final JSpinner deathDateSpinner;
    private final JCheckBox deathDateNullBox;
    private final JCheckBox birthDateNullBox;
    private final JComboBox birthDateTypeBox;
    private final JComboBox deathDateTypeBox;
    private final JTextArea commentsArea;
    public static final Date BIRTH_DATE = new Date();
    public static final Date DEATH_DATE = new Date();
    public static final String PROP_DECEASED_POST_SAVE = "deceasedPostSave";
    public static final String PROP_DECEASED_POST_DELETE = "deceasedPostDelete";

    public DeceasedForm(Context context, String title, Deceased deceased) throws SQLException {
        super(context, new IconHeader(context, title, "user.png"), Deceased.class, deceased);
        FormFactory ff = this.getFormFactory();
        List<DateType> dt = this.getDateTypes();
        this.burialPlotBox = ff.beanComboBox("burialPlot", this.getBurialPlots());
        this.deceasedTypeBox = ff.beanComboBox("deceasedType", this.getDeceasedTypes());
        this.firstNameField = ff.textField("firstName");
        this.birthNameField = ff.textField("birthName");
        this.nickNameField = ff.textField("nickName");
        this.lastNameField = ff.textField("lastName");
        this.birthDateSpinner = ff.dateSpinner("birthDate", BIRTH_DATE);
        this.deathDateSpinner = ff.dateSpinner("deathDate", DEATH_DATE);
        this.deathDateNullBox = ff.nullDateCheckBox("deathDate", this.deathDateSpinner);
        this.birthDateNullBox = ff.nullDateCheckBox("birthDate", this.birthDateSpinner);
        this.birthDateTypeBox = ff.dateTypeBox("birthDateType", this.birthDateSpinner, dt);
        this.deathDateTypeBox = ff.dateTypeBox("deathDateType", this.deathDateSpinner, dt);
        this.commentsArea = ff.textArea("comments");
        this.initForm();
        this.initComponents();
    }

    private List<BurialPlot> getBurialPlots() throws SQLException {
        return this.getContext().getDaoFactory().getBurialPlotDAO().queryForAll();
    }

    private List<DeceasedType> getDeceasedTypes() throws SQLException {
        return this.getContext().getDaoFactory().getDeceasedTypeDAO().queryForAll();
    }

    private List<DateType> getDateTypes() throws SQLException {
        return this.getContext().getDaoFactory().getDateTypeDao().queryForAll();
    }

    private void initComponents() {
        this.commentsArea.setRows(10);
        this.commentsArea.setLineWrap(true);
        this.commentsArea.setWrapStyleWord(true);
        this.burialPlotBox.setPrototypeDisplayValue("AAAAAAAA");
        ValidationComponentUtils.setMessageKey((JComponent)this.firstNameField, (Object)"firstName");
        ValidationComponentUtils.setMessageKey((JComponent)this.lastNameField, (Object)"lastName");
        ValidationComponentUtils.setMessageKey((JComponent)this.birthNameField, (Object)"birthName");
        ValidationComponentUtils.setMessageKey((JComponent)this.nickNameField, (Object)"nickName");
        ValidationComponentUtils.setMessageKey((JComponent)this.commentsArea, (Object)"comments");
        String unknown = this.getContext().getResourceBundle().getString("info.bean.unknown");
        PromptSupport.setPrompt((String)unknown, (JTextComponent)this.firstNameField);
        PromptSupport.setPrompt((String)unknown, (JTextComponent)this.lastNameField);
        PromptSupport.setPrompt((String)unknown, (JTextComponent)this.birthNameField);
        PromptSupport.setPrompt((String)unknown, (JTextComponent)this.nickNameField);
        this.burialPlotBox.setRenderer(new CustomRenderer(this.burialPlotBox.getRenderer(), this.getContext().getResourceBundle()));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    protected void buildForm(DefaultFormBuilder builder) {
        super.buildForm(builder);
        builder.appendI15d("form.deceased.burialplot", (Component)this.burialPlotBox, 5);
        builder.appendI15d("form.deceased.first_name", (Component)this.firstNameField, 5);
        builder.appendI15d("form.deceased.nick_name", (Component)this.nickNameField, 5);
        builder.appendI15d("form.deceased.birth_name", (Component)this.birthNameField, 5);
        builder.appendI15d("form.deceased.last_name", (Component)this.lastNameField, 5);
        builder.appendI15d("form.deceased.type", (Component)this.deceasedTypeBox, 5);
        builder.appendI15d("form.deceased.birth_date", (Component)this.birthDateSpinner, (Component)this.birthDateNullBox);
        builder.append((Component)this.birthDateTypeBox);
        builder.appendI15d("form.deceased.death_date", (Component)this.deathDateSpinner, (Component)this.deathDateNullBox);
        builder.append((Component)this.deathDateTypeBox);
        builder.appendI15d("form.deceased.comments", (Component)new JScrollPane(this.commentsArea), 5);
    }

    @Override
    protected void postSave() {
        this.firePropertyChange(PROP_DECEASED_POST_SAVE, null, this.getBean());
        this.dispose();
    }

    @Override
    protected void postDelete() {
        this.firePropertyChange(PROP_DECEASED_POST_DELETE, null, this.getBean());
        this.dispose();
    }

    private static final class CustomRenderer
    extends JLabel
    implements ListCellRenderer {
        private final ListCellRenderer original;
        private final ResourceBundle bundle;

        public CustomRenderer(ListCellRenderer original, ResourceBundle bundle) {
            this.original = original;
            this.bundle = bundle;
        }

        private String replace(Object value) {
            return value.toString().replace("UNKNOWN", this.bundle.getString("info.bean.unknown"));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return this.original.getListCellRendererComponent(list, this.replace(value), index, isSelected, cellHasFocus);
        }
    }
}

