/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs.forms.beans.model;

import beans.model.BurialPlot;
import beans.model.BurialPlotType;
import beans.model.Location;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.validation.view.ValidationComponentUtils;
import context.Context;
import dao.exceptions.SQLRuntimeException;
import gui.components.factory.form.FormFactory;
import gui.dialogs.forms.beans.model.AbstractModelForm;
import gui.dialogs.forms.beans.validators.exceptions.AnnotationValidatorException;
import gui.dialogs.forms.beans.validators.testers.InDatabaseTester;
import gui.dialogs.headers.IconHeader;
import java.awt.Component;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jdesktop.xswingx.PromptSupport;

public final class BurialPlotForm
extends AbstractModelForm<BurialPlot> {
    private final JComboBox locationBox;
    private final JComboBox bpTypesBox;
    private final JTextField nameField;
    private final JTextField referenceField;
    private final JSpinner sellDateSpinner;
    private final JSpinner capacitySpinner;
    private final JSpinner durationSpinner;
    private final JCheckBox sellDateNullBox;
    private final JCheckBox durationNullBox;
    private final JCheckBox capacityNullBox;
    private final JTextArea commentsArea;
    private final String originalRef;
    public static final Date SELL_DATE = new Date();
    public static final String PROP_BURIAL_PLOT_POST_SAVE = "burialPlotPostSave";
    public static final String PROP_BURIAL_PLOT_POST_DELETE = "burialPlotPostDelete";

    public BurialPlotForm(Context context, String title, BurialPlot burialPlot) throws SQLException {
        super(context, new IconHeader(context, title, "headstone.png"), BurialPlot.class, burialPlot);
        this.originalRef = burialPlot.getReference();
        FormFactory ff = this.getFormFactory();
        this.locationBox = ff.beanComboBox("location", this.getLocations());
        this.bpTypesBox = ff.beanComboBox("burialPlotType", this.getBurialPlotTypes());
        this.nameField = ff.textField("name");
        this.referenceField = ff.textField("reference");
        this.sellDateSpinner = ff.dateSpinner("sellDate", SELL_DATE);
        this.capacitySpinner = ff.numberSpinner("capacity", 1, 1, 50, 1);
        this.durationSpinner = ff.numberSpinner("duration", 1, 1, 100, 1);
        this.sellDateNullBox = ff.nullDateCheckBox("sellDate", this.sellDateSpinner);
        this.durationNullBox = ff.nullIntCheckBox("duration", this.durationSpinner);
        this.capacityNullBox = ff.nullIntCheckBox("capacity", this.capacitySpinner);
        this.commentsArea = ff.textArea("comments");
        this.initForm();
        this.initComponents();
    }

    private List<Location> getLocations() throws SQLException {
        return this.getContext().getDaoFactory().getLocationDAO().findAll(this.getContext().getConfiguration().getString("sorting", "alpha"));
    }

    private List<BurialPlotType> getBurialPlotTypes() throws SQLException {
        return this.getContext().getDaoFactory().getBurialPlotTypeDAO().queryForAll();
    }

    private void initComponents() throws SQLException {
        this.commentsArea.setRows(10);
        this.commentsArea.setLineWrap(true);
        this.commentsArea.setWrapStyleWord(true);
        this.sellDateSpinner.setEditor(new JSpinner.DateEditor(this.sellDateSpinner, "dd/MM/yyyy"));
        this.locationBox.setPrototypeDisplayValue("AAAAAAAA");
        String unknown = this.getContext().getResourceBundle().getString("info.bean.unknown");
        PromptSupport.setPrompt((String)unknown, (JTextComponent)this.nameField);
        PromptSupport.setPrompt((String)unknown, (JTextComponent)this.referenceField);
        ValidationComponentUtils.setMessageKey((JComponent)this.nameField, (Object)"name");
        ValidationComponentUtils.setMessageKey((JComponent)this.referenceField, (Object)"reference");
        ValidationComponentUtils.setMessageKey((JComponent)this.commentsArea, (Object)"comments");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    protected void buildForm(DefaultFormBuilder builder) {
        super.buildForm(builder);
        builder.appendI15d("form.burialplot.location", (Component)this.locationBox, 5);
        builder.appendI15d("form.burialplot.name", (Component)this.nameField, 5);
        builder.appendI15d("form.burialplot.reference", (Component)this.referenceField, 5);
        builder.appendI15d("form.burialplot.type", (Component)this.bpTypesBox, 5);
        builder.appendI15d("form.burialplot.capacity", (Component)this.capacitySpinner, (Component)this.capacityNullBox, 3);
        builder.appendI15d("form.burialplot.sell_date", (Component)this.sellDateSpinner, (Component)this.sellDateNullBox, 3);
        builder.appendI15d("form.burialplot.duration", (Component)this.durationSpinner, (Component)this.durationNullBox, 3);
        builder.appendI15d("form.burialplot.comments", (Component)new JScrollPane(this.commentsArea), 5);
    }

    @Override
    protected void postSave() {
        this.firePropertyChange(PROP_BURIAL_PLOT_POST_SAVE, null, this.getBean());
        this.dispose();
    }

    @Override
    protected void preValidate() {
        String reference = ((BurialPlot)this.getBean()).getReference();
        if (reference != null && reference.equals(this.originalRef)) {
            try {
                this.getValidator().addExclusion("reference", InDatabaseTester.class);
            }
            catch (AnnotationValidatorException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    protected boolean preDelete() {
        try {
            long count = this.getContext().getDaoFactory().getDeceasedDAO().countBy((BurialPlot)this.getBean());
            if (count > 0L) {
                JOptionPane.showMessageDialog(this, this.getContext().getResourceBundle().getString("form.burialplot.error"), this.getContext().getResourceBundle().getString("form.error"), 0);
                return false;
            }
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
        return true;
    }

    @Override
    protected void postDelete() {
        this.firePropertyChange(PROP_BURIAL_PLOT_POST_DELETE, null, this.getBean());
        this.dispose();
    }
}

