/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs.forms.beans.model;

import beans.model.AbstractModel;
import com.j256.ormlite.dao.Dao;
import com.jgoodies.binding.beans.BeanAdapter;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import context.Context;
import dao.exceptions.SQLRuntimeException;
import gui.components.JIcon;
import gui.components.factory.component.ComponentFactory;
import gui.components.factory.form.FormFactory;
import gui.components.factory.form.JGoodiesFormFactory;
import gui.dialogs.AbstractDialog;
import gui.dialogs.forms.beans.validators.AnnotationValidator;
import gui.dialogs.headers.HeaderPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public abstract class AbstractModelForm<T extends AbstractModel>
extends AbstractDialog {
    private final JTextField IDField = new JTextField();
    private final JButton saveButton;
    private final JButton deleteButton;
    private final AnnotationValidator<T> validator;
    private final Dao dao;
    private final T bean;
    private final FormFactory formFactory;
    public static final String LAYOUT = "r:p, 4dlu, 90dlu, 4dlu, 60dlu, 8dlu, 80dlu:g";

    public AbstractModelForm(Context context, HeaderPanel headerPanel, Class<T> clazz, T bean) throws SQLException {
        super(context, headerPanel);
        ResourceBundle rb = context.getResourceBundle();
        this.dao = context.getDaoFactory().getDao(clazz);
        this.bean = bean;
        this.formFactory = new JGoodiesFormFactory(rb, new BeanAdapter(bean));
        this.validator = new AnnotationValidator<T>(context, clazz);
        ComponentFactory cf = context.getComponentFactory();
        this.saveButton = cf.button("form.save", new JIcon("disk-black.png"));
        this.deleteButton = cf.button("form.delete", new JIcon("bin-metal.png"));
        this.initComponents();
    }

    private void initComponents() {
        this.getRootPane().setDefaultButton(this.saveButton);
        this.IDField.setEditable(false);
        if (((AbstractModel)this.bean).getId() == null) {
            ((AbstractModel)this.bean).setCreatedAt(new Date());
        } else {
            ((AbstractModel)this.bean).setUpdatedAt(new Date());
            this.IDField.setText(((AbstractModel)this.bean).getId().toString());
        }
        KeyAction keyAction = new KeyAction();
        this.saveButton.addKeyListener(keyAction);
        this.deleteButton.addKeyListener(keyAction);
        ButtonListener buttonListener = new ButtonListener();
        this.saveButton.addActionListener(buttonListener);
        this.deleteButton.addActionListener(buttonListener);
        this.setResizable(false);
    }

    public AnnotationValidator<T> getValidator() {
        return this.validator;
    }

    public T getBean() {
        return this.bean;
    }

    public FormFactory getFormFactory() {
        return this.formFactory;
    }

    protected final void initForm() {
        this.initForm(this.saveButton, LAYOUT);
    }

    @Override
    protected void buildForm(DefaultFormBuilder builder) {
        if (((AbstractModel)this.bean).getId() != null) {
            builder.append("ID", (Component)this.IDField, 5);
        }
    }

    @Override
    protected ButtonBarBuilder buttonBar(JButton button) {
        ButtonBarBuilder builder = super.buttonBar(button);
        if (((AbstractModel)this.bean).getId() != null) {
            builder.addRelatedGap().addButton((JComponent)this.deleteButton);
        }
        return builder;
    }

    private void save() throws SQLException {
        if (((AbstractModel)this.bean).getId() == null) {
            this.dao.create(this.bean);
        } else {
            this.dao.update(this.bean);
        }
    }

    private void delete() throws SQLException {
        this.dao.delete(this.bean);
    }

    protected void preValidate() {
    }

    protected void postSave() {
    }

    protected boolean preDelete() {
        return true;
    }

    protected void postDelete() {
    }

    private int showConfirmDialog(String messageKey, String messageTitle) {
        return JOptionPane.showConfirmDialog(this, this.getContext().getResourceBundle().getString(messageKey), this.getContext().getResourceBundle().getString(messageTitle), 0);
    }

    @Override
    protected boolean preClose() {
        int n = this.showConfirmDialog("form.cancel.confirm", "form.cancel");
        return n == 1;
    }

    private final class KeyAction
    extends AbstractDialog.KeyAction {
        private KeyAction() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            super.keyPressed(e);
            if (e.getKeyCode() == 10) {
                Object source = e.getSource();
                if (source.equals(AbstractModelForm.this.saveButton)) {
                    AbstractModelForm.this.saveButton.doClick();
                } else if (source.equals(AbstractModelForm.this.deleteButton)) {
                    AbstractModelForm.this.deleteButton.doClick();
                }
            }
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton source = (JButton)e.getSource();
            try {
                if (source.equals(AbstractModelForm.this.saveButton)) {
                    this.saveAction();
                } else if (source.equals(AbstractModelForm.this.deleteButton)) {
                    this.deleteAction();
                }
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
        }

        private void saveAction() throws SQLException {
            int n = AbstractModelForm.this.showConfirmDialog("form.save.confirm", "form.save");
            if (n == 0) {
                AbstractModelForm.this.preValidate();
                AbstractModelForm.this.validate(AbstractModelForm.this.validator.validate(AbstractModelForm.this.bean));
                if (!AbstractModelForm.this.hasErrors()) {
                    AbstractModelForm.this.save();
                    AbstractModelForm.this.postSave();
                }
            }
        }

        private void deleteAction() throws SQLException {
            int n = AbstractModelForm.this.showConfirmDialog("form.delete.confirm", "form.delete.confirm");
            if (n == 0 && AbstractModelForm.this.preDelete()) {
                AbstractModelForm.this.delete();
                AbstractModelForm.this.postDelete();
            }
        }
    }
}

