/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.util.DefaultValidationResultModel;
import com.jgoodies.validation.view.ValidationComponentUtils;
import com.jgoodies.validation.view.ValidationResultViewFactory;
import context.Context;
import gui.components.JIcon;
import gui.components.factory.component.ComponentFactory;
import gui.dialogs.headers.HeaderPanel;
import gui.dialogs.menu.i18n.I18nValidationResult;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public abstract class AbstractDialog
extends JDialog {
    private final JButton closeButton;
    private final HeaderPanel headerPanel;
    private final JPanel formPanel = new JPanel();
    private final Context context;
    private final ValidationResultModel validationResultModel = new DefaultValidationResultModel();

    public AbstractDialog(Context context, HeaderPanel headerPanel) {
        super(context.getMainFrame(), headerPanel.getI18nTitle(), true);
        this.context = context;
        this.headerPanel = headerPanel;
        ComponentFactory cf = context.getComponentFactory();
        this.closeButton = cf.button("dialog.close", new JIcon("cross.png"));
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.headerPanel, "First");
        this.add((Component)this.formPanel, "Center");
        this.closeButton.addActionListener(new CloseAction());
        this.closeButton.addKeyListener(new KeyAction());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractDialog.this.closeButton.doClick();
            }
        });
    }

    public final Context getContext() {
        return this.context;
    }

    public final JPanel getFormPanel() {
        return this.formPanel;
    }

    public final JButton getCloseButton() {
        return this.closeButton;
    }

    protected final void initForm(JButton button, String layout) {
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout(layout), this.getContext().getResourceBundle(), this.formPanel);
        builder.padding((EmptyBorder)Paddings.DIALOG);
        builder.defaultRowSpec(RowSpec.decode((String)"t:p"));
        this.buildForm(builder);
        builder.appendRow("7dlu");
        builder.appendRow("pref");
        builder.add((Component)this.buttonBar(button).build(), AbstractDialog.rightFullCC(builder));
        builder.appendRow("pref");
        builder.add((Component)this.getReport(), AbstractDialog.leftFullCC(builder));
        builder.build();
    }

    protected abstract void buildForm(DefaultFormBuilder var1);

    protected ButtonBarBuilder buttonBar(JButton button) {
        return new ButtonBarBuilder().addButton((JComponent)button).addRelatedGap().addButton((JComponent)this.closeButton);
    }

    public static final CellConstraints fullCC(DefaultFormBuilder builder, CellConstraints.Alignment align) {
        return new CellConstraints(1, builder.getRowCount(), builder.getColumnCount(), 1, align, CellConstraints.CENTER);
    }

    public static final CellConstraints leftFullCC(DefaultFormBuilder builder) {
        return AbstractDialog.fullCC(builder, CellConstraints.LEFT);
    }

    public static final CellConstraints rightFullCC(DefaultFormBuilder builder) {
        return AbstractDialog.fullCC(builder, CellConstraints.RIGHT);
    }

    protected boolean preClose() {
        return false;
    }

    protected void postClose() {
    }

    protected final JComponent getReport() {
        return ValidationResultViewFactory.createReportIconAndTextPane((ValidationResultModel)this.validationResultModel);
    }

    protected void enableButtons(boolean enable) {
        this.closeButton.setEnabled(enable);
        this.setCursor(enable ? null : Cursor.getPredefinedCursor(3));
    }

    protected final void validate(ValidationResult result) {
        this.validationResultModel.setResult(result);
        ValidationComponentUtils.updateComponentTreeSeverityBackground((Container)this.formPanel, (ValidationResult)this.validationResultModel.getResult());
        this.pack();
    }

    protected final void validate(I18nValidationResult result) {
        this.validate(result.getValidationResult());
    }

    protected final boolean hasErrors() {
        return this.validationResultModel.hasErrors();
    }

    protected class KeyAction
    implements KeyListener {
        protected KeyAction() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            Object source;
            if (e.getKeyCode() == 10 && (source = e.getSource()).equals(AbstractDialog.this.closeButton)) {
                AbstractDialog.this.closeButton.doClick();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private final class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AbstractDialog.this.preClose()) {
                return;
            }
            AbstractDialog.this.dispose();
            AbstractDialog.this.postClose();
        }
    }
}

