/*
 * Decompiled with CFR 0.152.
 */
package gui.components.factory.icon;

import gui.components.JIcon;
import gui.components.JIconBig;
import gui.components.JImage;
import gui.components.factory.icon.IconFactory;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.configuration.Configuration;

public final class JIconFactory
implements IconFactory {
    private final String imageDir;
    private final String iconDir;
    private final String iconBigDir;
    public static final String SEPARATOR = "/";

    public JIconFactory(Configuration configuration) {
        this.imageDir = SEPARATOR + configuration.getString("dir.images", "img") + SEPARATOR;
        this.iconDir = this.imageDir + configuration.getString("dir.images.icons", "icons") + SEPARATOR;
        this.iconBigDir = this.iconDir + configuration.getString("dir.images.icons.big", "24") + SEPARATOR;
    }

    @Override
    public ImageIcon createImageIcon(JIcon icon) {
        return this.createImageIcon(JIconFactory.class.getResource(this.iconDir + icon.getName()));
    }

    @Override
    public ImageIcon createImageIcon(JIconBig icon) {
        return this.createImageIcon(JIconFactory.class.getResource(this.iconBigDir + icon.getName()));
    }

    @Override
    public ImageIcon createImageIcon(JImage image) {
        return this.createImageIcon(JIconFactory.class.getResource(this.imageDir + image.getName()));
    }

    @Override
    public ImageIcon createImageIcon(URL url) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(url);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return new ImageIcon(image);
    }
}

