/*
 * Decompiled with CFR 0.152.
 */
package gui.components.factory.component;

import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.action.CAction;
import gui.components.JIcon;
import gui.components.JIconBig;
import gui.components.JIconTextField;
import gui.components.JImage;
import gui.components.factory.component.ComponentFactory;
import gui.components.factory.icon.IconFactory;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;

public final class I18nComponentFactory
implements ComponentFactory {
    private final ResourceBundle resourceBundle;
    private final IconFactory iconFactory;

    public I18nComponentFactory(IconFactory iconFactory, ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        this.iconFactory = iconFactory;
    }

    @Override
    public ImageIcon imageIcon(JIcon icon) {
        return this.iconFactory.createImageIcon(icon);
    }

    @Override
    public ImageIcon imageIcon(JIconBig icon) {
        return this.iconFactory.createImageIcon(icon);
    }

    @Override
    public ImageIcon imageIcon(JImage image) {
        return this.iconFactory.createImageIcon(image);
    }

    @Override
    public JButton button(String key, JIcon icon) {
        return new JButton(this.resourceBundle.getString(key), this.iconFactory.createImageIcon(icon));
    }

    @Override
    public JButton button(JIcon icon) {
        return new JButton(this.iconFactory.createImageIcon(icon));
    }

    @Override
    public JButton button(JIconBig icon) {
        return new JButton(this.iconFactory.createImageIcon(icon));
    }

    @Override
    public JCheckBox checkBox(String key) {
        return new JCheckBox(this.resourceBundle.getString(key));
    }

    @Override
    public JLabel label(String key) {
        return new JLabel(this.resourceBundle.getString(key));
    }

    @Override
    public JLabel label(JIcon icon) {
        return new JLabel(this.iconFactory.createImageIcon(icon));
    }

    @Override
    public JLabel label(JIconBig icon) {
        return new JLabel(this.iconFactory.createImageIcon(icon));
    }

    @Override
    public JLabel label(JImage image) {
        return new JLabel(this.iconFactory.createImageIcon(image));
    }

    @Override
    public JMenu menu(String key) {
        return new JMenu(this.resourceBundle.getString(key));
    }

    @Override
    public JMenuItem menuItem(String key) {
        return new JMenuItem(this.resourceBundle.getString(key));
    }

    @Override
    public JMenuItem menuItem(String key, JIcon icon) {
        return new JMenuItem(this.resourceBundle.getString(key), this.iconFactory.createImageIcon(icon));
    }

    @Override
    public JRadioButton radioButton(String key) {
        return new JRadioButton(this.resourceBundle.getString(key));
    }

    @Override
    public JRadioButton radioButton(String key, boolean selected) {
        return new JRadioButton(this.resourceBundle.getString(key), selected);
    }

    @Override
    public JToggleButton toggleButton(JIcon icon) {
        return new JToggleButton(this.iconFactory.createImageIcon(icon));
    }

    @Override
    public JToggleButton toggleButton(JIconBig icon) {
        return new JToggleButton(this.iconFactory.createImageIcon(icon));
    }

    @Override
    public JIconTextField iconTextField(String key, JIcon icon) {
        return new JIconTextField(this.resourceBundle.getString(key), this.iconFactory.createImageIcon(icon));
    }

    @Override
    public JIconTextField iconTextField(JIcon icon) {
        return new JIconTextField("", this.iconFactory.createImageIcon(icon));
    }

    @Override
    public DefaultSingleCDockable singleDockable(String id, String key, String icon) {
        return new DefaultSingleCDockable(id, (Icon)this.iconFactory.createImageIcon(new JIcon(icon)), this.resourceBundle.getString(key), new CAction[0]);
    }

    @Override
    public JPopupMenu popupMenu(String key) {
        return new JPopupMenu(this.resourceBundle.getString(key));
    }

    @Override
    public void setToolTipText(JComponent component, String key) {
        component.setToolTipText(this.resourceBundle.getString(key));
    }
}

