/*
 * Decompiled with CFR 0.152.
 */
package gui.components;

import java.awt.Component;
import java.awt.Frame;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;

public class JTabbedDialog<T extends JComponent>
extends JDialog {
    private final JTabbedPane tabbedPane = new JTabbedPane();

    public JTabbedDialog(Frame owner, String title) {
        super(owner, title);
        this.initComponents();
    }

    private void initComponents() {
        this.add(this.tabbedPane);
        this.setResizable(false);
    }

    public void loopOnTabs(Predicate<T> callBack) {
        int l = this.getTabCount();
        for (int i = 0; i < l; ++i) {
            callBack.test(this.getTab(i));
        }
    }

    public int getTabCount() {
        return this.tabbedPane.getTabCount();
    }

    public T getTab(int index) {
        return (T)((JComponent)this.tabbedPane.getComponentAt(index));
    }

    public T getSelectedTab() {
        return (T)((JComponent)this.tabbedPane.getComponentAt(this.tabbedPane.getSelectedIndex()));
    }

    public void setDefaultButton(JButton button) {
        this.tabbedPane.getRootPane().setDefaultButton(button);
    }

    public void addTab(String title, Icon icon, T component) {
        this.tabbedPane.addTab(title, icon, (Component)component);
    }

    public void addChangeListener(ChangeListener listener) {
        this.tabbedPane.addChangeListener(listener);
    }
}

