/*
 * Decompiled with CFR 0.152.
 */
package gui;

import beans.model.Cimetary;
import beans.model.DataNode;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.common.theme.ThemeMap;
import context.Context;
import dao.exceptions.SQLRuntimeException;
import gui.components.JIcon;
import gui.components.JImage;
import gui.components.factory.component.ComponentFactory;
import gui.dialogs.AbstractDialog;
import gui.dialogs.forms.beans.model.AbstractModelForm;
import gui.dialogs.menu.AboutDialog;
import gui.dialogs.menu.ExportDialog;
import gui.dialogs.menu.ImportDialog;
import gui.dialogs.menu.LoginDialog;
import gui.dialogs.menu.MapImportDialog;
import gui.dialogs.menu.ResetDbDialog;
import gui.exceptions.AuthorizeFileException;
import gui.exceptions.ContextException;
import gui.exceptions.FileNotAuthorizedException;
import gui.exceptions.LookAndFeelException;
import gui.exceptions.SplashScreenException;
import gui.handlers.DocumentHandler;
import gui.listeners.actions.InfoPanelActions;
import gui.listeners.actions.LayersPanelActions;
import gui.listeners.actions.MapPanelActions;
import gui.listeners.actions.StatusPanelActions;
import gui.listeners.actions.TreePanelActions;
import gui.panels.InfoPanel;
import gui.panels.LayersPanel;
import gui.panels.MapPanel;
import gui.panels.StatusPanel;
import gui.panels.ToolBar;
import gui.panels.TreePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.SQLException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shiro.session.ExpiredSessionException;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.subject.Subject;
import org.kabeja.parser.ParseException;

public final class MainFrame
extends JFrame {
    private final JMenuBar menuBar = new JMenuBar();
    private final JMenu cimExplorerMenu;
    private final JMenu dbMenu;
    private final JMenu displayMenu;
    private final JMenuItem aboutItem;
    private final JMenuItem pageSetupItem;
    private final JMenuItem exitItem;
    private final JMenuItem exportItem;
    private final JMenuItem importItem;
    private final JMenuItem resetDbItem;
    private final JMenuItem mapImportItem;
    private final JMenuItem resetLayoutItem;
    private final JMenuItem newSubMenu;
    private final JMenuItem locationItem;
    private final JMenuItem burialPlotItem;
    private final JMenuItem deceasedItem;
    private final JMenuItem dxfAuthItem;
    private final Context context;
    private final DocumentHandler documentHandler;
    public static final Log LOGGER = LogFactory.getLog(MainFrame.class);
    public static final String DOCK_MAP = "map";
    public static final String DOCK_TREE = "tree";
    public static final String DOCK_LAYERS = "layers";
    public static final String DOCK_INFOS = "infos";
    public static final String PROP_DISPLAY_PAGE_SETUP = "displayPageSetup";

    public MainFrame(Context context) throws HeadlessException, ParseException, FileNotFoundException, FileNotAuthorizedException, ExpiredSessionException {
        this.context = context;
        LoginDialog loginDialog = new LoginDialog(context);
        loginDialog.setVisible(true);
        this.documentHandler = new DocumentHandler(context);
        ComponentFactory cf = context.getComponentFactory();
        this.cimExplorerMenu = cf.menu("menu.cim");
        this.dbMenu = cf.menu("menu.db");
        this.displayMenu = cf.menu("menu.display");
        this.newSubMenu = cf.menu("menu.cim.new");
        this.aboutItem = cf.menuItem("menu.cim.about", new JIcon("about.png"));
        this.pageSetupItem = cf.menuItem("menu.cim.page_setup", new JIcon("page-setup.png"));
        this.exitItem = cf.menuItem("menu.cim.exit", new JIcon("exit.png"));
        this.exportItem = cf.menuItem("menu.db.export", new JIcon("export.png"));
        this.importItem = cf.menuItem("menu.db.import", new JIcon("import.png"));
        this.resetDbItem = cf.menuItem("menu.db.reset", new JIcon("bin-metal.png"));
        this.mapImportItem = cf.menuItem("menu.db.map_import", new JIcon("import.png"));
        this.resetLayoutItem = cf.menuItem("menu.display.reset", new JIcon("application-tile.png"));
        this.locationItem = cf.menuItem("menu.cim.new.location", new JIcon("marker.png"));
        this.burialPlotItem = cf.menuItem("menu.cim.new.burialplot", new JIcon("headstone.png"));
        this.deceasedItem = cf.menuItem("menu.cim.new.deceased", new JIcon("user.png"));
        this.dxfAuthItem = cf.menuItem(this.documentHandler.isDxfFileAuth() ? "menu.cim.dxf_auth_ok" : "menu.cim.dxf_auth", new JIcon(this.documentHandler.isDxfFileAuth() ? "tick-shield.png" : "cross-shield.png"));
        this.initComponents();
    }

    public void initComponents() throws FileNotAuthorizedException {
        ResourceBundle rb = this.context.getResourceBundle();
        ComponentFactory cf = this.context.getComponentFactory();
        Subject sb = this.context.getSubject();
        if (!sb.isPermitted("administrate") && !this.documentHandler.isDxfFileAuth()) {
            throw new FileNotAuthorizedException();
        }
        this.documentHandler.loadLayers();
        this.setTitle(rb.getString("menu.title"));
        this.setLayout(new BorderLayout());
        this.setIconImage(cf.imageIcon(new JImage("logo.png")).getImage());
        this.setDefaultCloseOperation(3);
        this.context.setMainFrame(this);
        this.newSubMenu.setIcon(cf.imageIcon(new JIcon("plus.png")));
        if (sb.isPermitted("administrate")) {
            this.newSubMenu.add(this.locationItem);
            this.cimExplorerMenu.add(this.dxfAuthItem);
            this.cimExplorerMenu.addSeparator();
        }
        this.newSubMenu.add(this.burialPlotItem);
        this.newSubMenu.add(this.deceasedItem);
        if (sb.isPermitted("update")) {
            this.cimExplorerMenu.add(this.newSubMenu);
            this.cimExplorerMenu.addSeparator();
        }
        this.cimExplorerMenu.add(this.pageSetupItem);
        this.cimExplorerMenu.addSeparator();
        this.cimExplorerMenu.add(this.aboutItem);
        this.cimExplorerMenu.addSeparator();
        this.cimExplorerMenu.add(this.exitItem);
        this.displayMenu.add(this.resetLayoutItem);
        this.dbMenu.add(this.exportItem);
        if (sb.isPermitted("administrate")) {
            this.dbMenu.addSeparator();
            this.dbMenu.add(this.importItem);
            this.dbMenu.add(this.mapImportItem);
            this.dbMenu.addSeparator();
            this.dbMenu.add(this.resetDbItem);
        }
        this.menuBar.add(this.cimExplorerMenu);
        this.menuBar.add(this.dbMenu);
        this.menuBar.add(this.displayMenu);
        this.setJMenuBar(this.menuBar);
        try {
            this.context.getDaoFactory().beginConnectionScope();
            this.context.getDaoFactory().migrateTables();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
        TreePanel treePanel = new TreePanel(this.context);
        InfoPanel infoPanel = new InfoPanel(this.context);
        StatusPanel statusPanel = new StatusPanel(this.context);
        MapPanel mapPanel = new MapPanel(this.context, this.documentHandler);
        LayersPanel layersPanel = new LayersPanel(this.context, this.documentHandler);
        ToolBar toolBar = new ToolBar(this.context);
        StatusPanelActions statusPanelActions = new StatusPanelActions(statusPanel);
        TreePanelActions treePanelActions = new TreePanelActions(treePanel);
        InfoPanelActions infoPanelActions = new InfoPanelActions(infoPanel);
        MapPanelActions mapPanelActions = new MapPanelActions(mapPanel);
        LayersPanelActions layersPanelActions = new LayersPanelActions(layersPanel);
        mapPanel.addPropertyChangeListener(statusPanelActions);
        mapPanel.addPropertyChangeListener(treePanelActions);
        layersPanel.addPropertyChangeListener(mapPanelActions);
        treePanel.addPropertyChangeListener(mapPanelActions);
        treePanel.addPropertyChangeListener(infoPanelActions);
        toolBar.addPropertyChangeListener(mapPanelActions);
        toolBar.addPropertyChangeListener(layersPanelActions);
        toolBar.addPropertyChangeListener(treePanelActions);
        infoPanel.addPropertyChangeListener(treePanelActions);
        this.addPropertyChangeListener(mapPanelActions);
        CimExplorerMenuListener fileMenuListener = new CimExplorerMenuListener();
        this.aboutItem.addActionListener(fileMenuListener);
        this.exitItem.addActionListener(fileMenuListener);
        this.pageSetupItem.addActionListener(fileMenuListener);
        this.dxfAuthItem.addActionListener(fileMenuListener);
        NewMenuListener newMenuListener = new NewMenuListener(treePanelActions);
        this.locationItem.addActionListener(newMenuListener);
        this.burialPlotItem.addActionListener(newMenuListener);
        this.deceasedItem.addActionListener(newMenuListener);
        DataMenuListener dataMenuListener = new DataMenuListener(treePanelActions);
        this.importItem.addActionListener(dataMenuListener);
        this.exportItem.addActionListener(dataMenuListener);
        this.resetDbItem.addActionListener(dataMenuListener);
        this.mapImportItem.addActionListener(dataMenuListener);
        this.addWindowListener(new WindowListener());
        CControl control = new CControl((JFrame)this);
        ThemeMap themes = control.getThemes();
        themes.select("eclipse");
        DefaultSingleCDockable mapDock = cf.singleDockable(DOCK_MAP, "dock.map", "map.png");
        DefaultSingleCDockable treeDock = cf.singleDockable(DOCK_TREE, "dock.tree", "database.png");
        DefaultSingleCDockable infoDock = cf.singleDockable(DOCK_INFOS, "dock.infos", "about.png");
        DefaultSingleCDockable layersDock = cf.singleDockable(DOCK_LAYERS, "dock.layers", "layers.png");
        mapDock.add((Component)mapPanel);
        mapDock.setCloseable(false);
        mapDock.setExternalizable(false);
        mapDock.setMinimizable(false);
        treeDock.add((Component)treePanel);
        treeDock.setCloseable(false);
        treeDock.setExternalizable(false);
        treeDock.setMinimizable(false);
        treeDock.setMaximizable(false);
        layersDock.add((Component)layersPanel);
        layersDock.setCloseable(false);
        layersDock.setExternalizable(false);
        layersDock.setMinimizable(false);
        layersDock.setMaximizable(false);
        infoDock.add((Component)infoPanel);
        infoDock.setCloseable(false);
        infoDock.setExternalizable(false);
        infoDock.setMaximizable(false);
        CGrid grid = new CGrid(control);
        grid.add(0.0, 0.0, 2.0, 2.0, new CDockable[]{mapDock});
        grid.add(2.0, 0.0, 1.0, 1.0, new CDockable[]{treeDock, layersDock});
        grid.add(2.0, 1.0, 1.0, 1.0, new CDockable[]{infoDock});
        control.getContentArea().deploy(grid);
        infoDock.setLocation((CLocation)CLocation.base().minimalEast());
        infoDock.setExtendedMode(ExtendedMode.NORMALIZED);
        treeDock.toFront();
        mapDock.toFront();
        this.resetLayoutItem.addActionListener(e -> {
            control.getContentArea().deploy(grid);
            treeDock.toFront();
            mapDock.toFront();
        });
        this.add((Component)toolBar, "Before");
        this.add((Component)control.getContentArea(), "Center");
        this.add((Component)statusPanel, "Last");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void exit() {
        this.dispatchEvent(new WindowEvent(this, 201));
        this.setVisible(false);
        this.dispose();
        System.exit(0);
    }

    public Context getContext() {
        return this.context;
    }

    private static void manageError(Context context, String key, Exception ex) {
        String message = context.getResourceBundle().getString(key);
        LOGGER.error((Object)message, (Throwable)ex);
        JOptionPane.showMessageDialog(null, message, message, 0);
        System.exit(0);
    }

    private static void manageFatal(String message, Throwable t) {
        LOGGER.fatal((Object)message, t);
        System.exit(0);
    }

    private static void setLookAndFeel() throws LookAndFeelException {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            throw new LookAndFeelException("Look and Feel error", ex);
        }
    }

    private static void showSplashScreen(Context context) throws SplashScreenException {
        SplashScreen splash = SplashScreen.getSplashScreen();
        if (splash == null) {
            throw new SplashScreenException("SplashScreen.getSplashScreen() returned null");
        }
        try {
            splash.setImageURL(context.getSplashScreenURL());
        }
        catch (FileNotFoundException | MalformedURLException ex) {
            throw new SplashScreenException("Splash screen file error", ex);
        }
        catch (IOException | IllegalStateException | NullPointerException ex) {
            throw new SplashScreenException("Splash screen URL error", ex);
        }
    }

    private static void sleep(Context context) throws InterruptedException {
        long sleep = context.getConfiguration().getLong("splash_sleep", 2000L);
        if (sleep >= 0L) {
            Thread.sleep(sleep);
        }
    }

    private static void pushEventQueueProxy(Context context) {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(context.newEventQueueProxy());
    }

    public static void main(String[] args) {
        LOGGER.info((Object)"Starting CimExplorer");
        Locale.setDefault(Context.LOCALE_DEFAULT);
        try {
            Context context = new Context();
            MainFrame.showSplashScreen(context);
            MainFrame.sleep(context);
            MainFrame.pushEventQueueProxy(context);
            MainFrame.setLookAndFeel();
            EventQueue.invokeLater(() -> {
                try {
                    MainFrame mainFrame = new MainFrame(context);
                    mainFrame.setVisible(true);
                }
                catch (ParseException ex) {
                    MainFrame.manageError(context, "error.dxf.parse", ex);
                }
                catch (FileNotAuthorizedException ex) {
                    MainFrame.manageError(context, "error.dxf.auth", ex);
                }
                catch (FileNotFoundException ex) {
                    MainFrame.manageError(context, "error.dxf.found", ex);
                }
                catch (ExpiredSessionException ex) {
                    MainFrame.manageError(context, "error.session", (Exception)((Object)ex));
                }
            });
        }
        catch (ContextException ex) {
            MainFrame.manageFatal("Application context fatal error", ex);
        }
        catch (SplashScreenException ex) {
            MainFrame.manageFatal("Splash screen error", ex);
        }
        catch (LookAndFeelException ex) {
            MainFrame.manageFatal("Look and feel error", ex);
        }
        catch (InterruptedException ex) {
            MainFrame.manageFatal("Sleep error", ex);
        }
        catch (ConversionException ex) {
            MainFrame.manageFatal("Configuration error", ex);
        }
    }

    private final class DataMenuListener
    implements ActionListener {
        private final TreePanelActions treePanelActions;

        public DataMenuListener(TreePanelActions treePanelActions) {
            this.treePanelActions = treePanelActions;
        }

        private AbstractDialog getDialog(Object source) {
            if (source.equals(MainFrame.this.exportItem)) {
                return new ExportDialog(MainFrame.this.context);
            }
            if (source.equals(MainFrame.this.importItem)) {
                return new ImportDialog(MainFrame.this.context);
            }
            if (source.equals(MainFrame.this.resetDbItem)) {
                return new ResetDbDialog(MainFrame.this.context);
            }
            return new MapImportDialog(MainFrame.this.context, MainFrame.this.documentHandler);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractDialog dialog = this.getDialog(e.getSource());
            dialog.addPropertyChangeListener(this.treePanelActions);
            dialog.setVisible(true);
        }
    }

    private final class CimExplorerMenuListener
    implements ActionListener {
        private CimExplorerMenuListener() {
        }

        private void manageDxfAuth() {
            ResourceBundle rb = MainFrame.this.context.getResourceBundle();
            if (MainFrame.this.documentHandler.isDxfFileAuth()) {
                JOptionPane.showMessageDialog(MainFrame.this, rb.getString("dxf.auth_already"));
            } else {
                try {
                    MainFrame.this.documentHandler.authorizeDxf();
                    JOptionPane.showMessageDialog(MainFrame.this, rb.getString("dxf.auth_ok"));
                    MainFrame.this.exit();
                }
                catch (AuthorizeFileException ex) {
                    JOptionPane.showMessageDialog(MainFrame.this, rb.getString("dxf.auth_error"), rb.getString("error"), 0);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem source = (JMenuItem)e.getSource();
            if (source.equals(MainFrame.this.exitItem)) {
                MainFrame.this.exit();
            } else if (source.equals(MainFrame.this.pageSetupItem)) {
                MainFrame.this.firePropertyChange(MainFrame.PROP_DISPLAY_PAGE_SETUP, null, true);
            } else if (source.equals(MainFrame.this.aboutItem)) {
                AboutDialog aboutDialog = new AboutDialog(MainFrame.this.context);
                aboutDialog.setVisible(true);
            } else if (source.equals(MainFrame.this.dxfAuthItem)) {
                this.manageDxfAuth();
            }
        }
    }

    private final class NewMenuListener
    implements ActionListener {
        private final TreePanelActions actions;

        public NewMenuListener(TreePanelActions actions) {
            this.actions = actions;
        }

        private void newCreateForm(DataNode node) throws SQLException {
            AbstractModelForm form = node.getCreateForm(MainFrame.this.context);
            form.addPropertyChangeListener(this.actions);
            form.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem source = (JMenuItem)e.getSource();
            try {
                if (source.equals(MainFrame.this.locationItem)) {
                    this.newCreateForm(new Cimetary());
                } else if (source.equals(MainFrame.this.burialPlotItem)) {
                    this.newCreateForm((DataNode)MainFrame.this.context.getDaoFactory().getLocationDAO().queryBuilder().queryForFirst());
                } else if (source.equals(MainFrame.this.deceasedItem)) {
                    this.newCreateForm((DataNode)MainFrame.this.context.getDaoFactory().getBurialPlotDAO().queryBuilder().queryForFirst());
                }
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
        }
    }

    private final class WindowListener
    extends WindowAdapter {
        private WindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            try {
                MainFrame.this.context.getDaoFactory().endConnectionScope();
                MainFrame.this.context.getSubject().logout();
            }
            catch (IOException ex) {
                LOGGER.error((Object)"Error closing window", (Throwable)ex);
            }
            catch (UnknownSessionException unknownSessionException) {
                // empty catch block
            }
            LOGGER.info((Object)"Stopping CimExplorer");
        }
    }
}

