/*
 * Decompiled with CFR 0.152.
 */
package gui;

import dao.DaoFactory;
import dao.exceptions.SQLRuntimeException;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EventQueueProxy
extends EventQueue {
    private final ResourceBundle resourceBundle;
    private final DaoFactory daoFactory;
    public static final Log LOGGER = LogFactory.getLog(EventQueueProxy.class);

    public EventQueueProxy(ResourceBundle resourceBundle, DaoFactory daoFactory) {
        this.resourceBundle = resourceBundle;
        this.daoFactory = daoFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageError(String message, String key, Throwable t) {
        LOGGER.error((Object)message, t);
        JOptionPane.showMessageDialog(null, this.resourceBundle.getString(key), this.resourceBundle.getString("error"), 0);
        try {
            this.daoFactory.endConnectionScope();
        }
        catch (IOException iOException) {
        }
        finally {
            System.exit(0);
        }
    }

    @Override
    protected void dispatchEvent(AWTEvent newEvent) {
        try {
            super.dispatchEvent(newEvent);
        }
        catch (SQLRuntimeException ex) {
            this.manageError("Database error " + ex.getSQLState(), "error.db", ex);
        }
        catch (Throwable t) {
            this.manageError("Runtime error", "error.general", t);
        }
    }
}

