/*
 * Decompiled with CFR 0.152.
 */
package geom.utils;

import java.awt.Graphics2D;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import org.kabeja.dxf.DXFVertex;

public final class GeomUtils {
    public static boolean isEqual(double d1, double d2) {
        BigDecimal b1 = new BigDecimal(d1);
        BigDecimal b2 = new BigDecimal(d2);
        return b1.compareTo(b2) == 0;
    }

    public static boolean isZero(double d) {
        return GeomUtils.isEqual(d, 0.0);
    }

    public static boolean isEqual(DXFVertex v1, DXFVertex v2) {
        return GeomUtils.isEqual(v1.getX(), v2.getX()) && GeomUtils.isEqual(v1.getY(), v2.getY());
    }

    public static Graphics2D createGraphics() {
        return new BufferedImage(1, 1, 2).createGraphics();
    }

    public static int getTextHeight() {
        return GeomUtils.createGraphics().getFontMetrics().getHeight();
    }

    public static Rectangle2D getTextBounds(String text) {
        Graphics2D g2d = GeomUtils.createGraphics();
        GlyphVector gv = g2d.getFont().createGlyphVector(g2d.getFontRenderContext(), text);
        return gv.getVisualBounds();
    }
}

