/*
 * Decompiled with CFR 0.152.
 */
package geom.entities.shapes;

import geom.entities.Entity;
import geom.utils.GeomUtils;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFViewport;
import org.kabeja.dxf.helpers.Point;

public final class Viewport
extends Entity<DXFViewport> {
    public Viewport(DXFViewport entity) {
        super(entity);
    }

    public static Point boundsToPoint(Bounds bounds) {
        return new Point(bounds.getCenterX(), bounds.getCenterY(), bounds.getCenterZ());
    }

    public static DXFViewport convert(Bounds bounds) {
        DXFViewport viewport = new DXFViewport();
        viewport.setCenterPoint(Viewport.boundsToPoint(bounds));
        viewport.setWidth(bounds.getWidth());
        viewport.setHeight(bounds.getHeight());
        viewport.setAspectRatio(bounds.getWidth() / bounds.getHeight());
        viewport.setTwistAngle(0.0);
        return viewport;
    }

    public static Bounds convert(DXFViewport viewport) {
        double h = viewport.getHeight() / 2.0;
        double w = viewport.getHeight() * viewport.getAspectRatio() / 2.0;
        Bounds bounds = new Bounds();
        bounds.addToBounds(viewport.getCenterPoint().getX() + w, viewport.getCenterPoint().getY() + h, viewport.getCenterPoint().getZ());
        bounds.addToBounds(viewport.getCenterPoint().getX() - w, viewport.getCenterPoint().getY() - h, viewport.getCenterPoint().getZ());
        return bounds;
    }

    public double getAspectRatio() {
        return ((DXFViewport)this.getEntity()).getAspectRatio();
    }

    public double getTwistAngle() {
        return Math.toRadians(((DXFViewport)this.getEntity()).getTwistAngle());
    }

    public double getWidth() {
        if (GeomUtils.isZero(((DXFViewport)this.getEntity()).getWidth())) {
            return ((DXFViewport)this.getEntity()).getHeight() * ((DXFViewport)this.getEntity()).getAspectRatio();
        }
        return ((DXFViewport)this.getEntity()).getWidth();
    }

    public double getHeight() {
        if (GeomUtils.isZero(((DXFViewport)this.getEntity()).getHeight()) && !GeomUtils.isZero(((DXFViewport)this.getEntity()).getAspectRatio())) {
            return ((DXFViewport)this.getEntity()).getWidth() / ((DXFViewport)this.getEntity()).getAspectRatio();
        }
        return ((DXFViewport)this.getEntity()).getHeight();
    }

    public double getCenterX() {
        return ((DXFViewport)this.getEntity()).getCenterPoint().getX();
    }

    public double getCenterY() {
        return ((DXFViewport)this.getEntity()).getCenterPoint().getY();
    }

    @Override
    protected Shape makeShape() {
        double h = ((DXFViewport)this.getEntity()).getHeight();
        double w = ((DXFViewport)this.getEntity()).getHeight() * ((DXFViewport)this.getEntity()).getAspectRatio();
        double x = ((DXFViewport)this.getEntity()).getCenterPoint().getX() - w / 2.0;
        double y = ((DXFViewport)this.getEntity()).getCenterPoint().getY() - h / 2.0;
        return new Rectangle2D.Double(x, y, w, h);
    }

    @Override
    protected Path2D makeClip() {
        return null;
    }

    @Override
    protected BasicStroke makeStroke() {
        return null;
    }

    @Override
    protected AffineTransform makeTransform() {
        return null;
    }
}

