/*
 * Decompiled with CFR 0.152.
 */
package geom.entities.shapes;

import geom.entities.Entity;
import geom.utils.GeomUtils;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.kabeja.dxf.DXFText;
import org.kabeja.dxf.helpers.Point;

public class Text
extends Entity<DXFText> {
    public static final int FONT_HEIGHT = 12;

    public Text(DXFText entity) {
        super(entity);
    }

    @Override
    protected AffineTransform makeTransform() {
        Rectangle2D b = GeomUtils.getTextBounds(((DXFText)this.getEntity()).getText());
        double scaleY = ((DXFText)this.getEntity()).getHeight() / b.getHeight();
        double scaleX = scaleY * ((DXFText)this.getEntity()).getScaleX();
        Point p = ((DXFText)this.getEntity()).calculateAlignmentPoint();
        AffineTransform at = AffineTransform.getTranslateInstance(p.getX(), p.getY());
        at.rotate(Math.toRadians(((DXFText)this.getEntity()).getRotation()));
        at.shear(Math.tan(Math.toRadians(((DXFText)this.getEntity()).getObliqueAngle())), 0.0);
        at.scale(scaleX, -scaleY);
        at.translate(this.getAlign(b.getWidth()), -this.getVAlign(b.getHeight()));
        return at;
    }

    private double getAlign(double width) {
        switch (((DXFText)this.getEntity()).getAlign()) {
            case 1: 
            case 4: {
                return -width / 2.0;
            }
            case 2: 
            case 3: 
            case 5: {
                return -width;
            }
        }
        return 0.0;
    }

    private double getVAlign(double height) {
        switch (((DXFText)this.getEntity()).getValign()) {
            case 2: {
                return -height / 2.0;
            }
            case 3: {
                return -height;
            }
        }
        return 0.0;
    }

    @Override
    protected void doDraw(Graphics2D g2d) {
        g2d.drawString(((DXFText)this.getEntity()).getText(), 0, 0);
    }

    @Override
    public boolean contains(Point2D point) {
        return false;
    }

    @Override
    public Shape makeShape() {
        return null;
    }

    @Override
    protected Path2D makeClip() {
        return null;
    }

    @Override
    protected BasicStroke makeStroke() {
        return null;
    }
}

