/*
 * Decompiled with CFR 0.152.
 */
package geom.entities.shapes;

import geom.entities.Entity;
import geom.utils.GeomUtils;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.util.Iterator;
import org.kabeja.dxf.DXFPolyline;
import org.kabeja.dxf.DXFVertex;

public class Polyline
extends Entity<DXFPolyline> {
    public Polyline(DXFPolyline entity) {
        super(entity);
    }

    @Override
    protected Shape makeShape() {
        Iterator it = ((DXFPolyline)this.getEntity()).getVertexIterator();
        Path2D.Double path2D = new Path2D.Double(0, ((DXFPolyline)this.getEntity()).getVertexCount());
        DXFVertex prevVtx = null;
        DXFVertex firstVtx = ((DXFPolyline)this.getEntity()).getVertex(0);
        boolean firstDraw = false;
        while (it.hasNext()) {
            DXFVertex curVtx = (DXFVertex)it.next();
            if (prevVtx != null && !GeomUtils.isEqual(prevVtx, curVtx)) {
                if (!GeomUtils.isZero(prevVtx.getBulge())) {
                    ((Path2D)path2D).append(this.createFlatBulge(prevVtx, curVtx, prevVtx.getBulge(), 10.0), firstDraw);
                } else {
                    path2D.append(this.createLine(prevVtx, curVtx), firstDraw);
                }
                if (!firstDraw) {
                    firstDraw = true;
                }
            }
            prevVtx = curVtx;
        }
        if (((DXFPolyline)this.getEntity()).isClosed()) {
            if (prevVtx != null && !GeomUtils.isEqual(prevVtx, firstVtx) && !GeomUtils.isZero(prevVtx.getBulge())) {
                ((Path2D)path2D).append(this.createFlatBulge(prevVtx, firstVtx, prevVtx.getBulge(), 10.0), true);
            }
            path2D.closePath();
        }
        return path2D;
    }

    private Line2D createLine(DXFVertex v1, DXFVertex v2) {
        return new Line2D.Double(v1.getX(), v1.getY(), v2.getX(), v2.getY());
    }

    private Arc2D createBulge(DXFVertex v1, DXFVertex v2, double b) {
        double x1 = v1.getX();
        double x2 = v2.getX();
        double y1 = v1.getY();
        double y2 = v2.getY();
        int sign = b > 0.0 ? 1 : -1;
        double alpha = 4.0 * Math.atan(Math.abs(b));
        double l = Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
        double r = l / (2.0 * Math.sin(alpha / 2.0));
        double d = 2.0 * r;
        double h = l * (1.0 - Math.pow(b, 2.0)) / (4.0 * Math.abs(b));
        double u = (x2 - x1) / l;
        double v = (y2 - y1) / l;
        double cx = (x1 + x2) / 2.0 - (double)sign * h * v;
        double cy = (y1 + y2) / 2.0 + (double)sign * h * u;
        double theta = Math.atan2(y1 - cy, x1 - cx);
        return new Arc2D.Double(cx - r, cy - r, d, d, -Math.toDegrees(theta), (double)(-sign) * Math.toDegrees(alpha), 0);
    }

    private FlatteningPathIterator createFlatBulge(DXFVertex v1, DXFVertex v2, double bulge, double smoothness) {
        return this.getFlatteningPathIterator(this.createBulge(v1, v2, bulge), smoothness);
    }

    private FlatteningPathIterator getFlatteningPathIterator(Arc2D bulge, double smoothness) {
        double flatness = bulge.getBounds2D().getWidth() / smoothness;
        return new FlatteningPathIterator(bulge.getPathIterator(null), flatness);
    }

    @Override
    protected Path2D makeClip() {
        return null;
    }

    @Override
    protected BasicStroke makeStroke() {
        return null;
    }

    @Override
    protected AffineTransform makeTransform() {
        return null;
    }
}

