/*
 * Decompiled with CFR 0.152.
 */
package geom.entities.shapes;

import geom.AbstractShape;
import geom.ShapeVisitor;
import gui.handlers.ColorHandler;
import gui.panels.ToolBar;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

public final class Paragraph
extends AbstractShape {
    private final int offset;
    private final int dxfColor;
    private final String text;
    private ColorHandler colorHandler = ToolBar.getColorHandler(false);

    public Paragraph(int offset, String text, int dxfColor) {
        this.offset = offset;
        this.text = text;
        this.dxfColor = dxfColor;
    }

    @Override
    public void accept(ShapeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected Color makeColor() {
        if (this.dxfColor != 0) {
            return this.colorHandler.toColor(this.dxfColor);
        }
        return null;
    }

    @Override
    protected Color makeFillColor() {
        return null;
    }

    @Override
    protected Path2D makeClip() {
        return null;
    }

    @Override
    protected BasicStroke makeStroke() {
        return null;
    }

    @Override
    protected AffineTransform makeTransform() {
        return null;
    }

    @Override
    protected void doDraw(Graphics2D g2d) {
        g2d.drawString(this.text, 0, this.offset);
    }

    @Override
    protected void doFill(Graphics2D g2d) {
    }

    @Override
    public boolean contains(Point2D p) {
        return false;
    }

    @Override
    public AbstractShape doMatch(String handle) {
        return null;
    }

    @Override
    public AbstractShape doMatch(Point2D p) {
        return null;
    }

    @Override
    public String getHandle() {
        return null;
    }

    @Override
    public Point2D getPosition() {
        return null;
    }

    public ColorHandler getColorHandler() {
        return this.colorHandler;
    }

    public void setColorHandler(ColorHandler colorHandler) {
        this.colorHandler = colorHandler;
    }
}

