/*
 * Decompiled with CFR 0.152.
 */
package geom.entities.shapes;

import geom.entities.CompositeEntity;
import geom.entities.shapes.Paragraph;
import geom.utils.GeomUtils;
import java.awt.BasicStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import org.kabeja.dxf.DXFMText;
import org.kabeja.dxf.helpers.StyledTextParagraph;

public final class MText
extends CompositeEntity<DXFMText> {
    public MText(DXFMText entity) {
        super(entity);
    }

    @Override
    protected void addShapes() {
        Iterator it = this.getParagraphIterator();
        int layerColor = this.getLayerColor();
        int textHeight = GeomUtils.getTextHeight();
        int offset = 0;
        int dxfColor = 0;
        boolean first = true;
        while (it.hasNext()) {
            StyledTextParagraph p = (StyledTextParagraph)it.next();
            if (first) {
                dxfColor = p.getColor() == 256 ? layerColor : p.getColor();
                first = false;
            }
            if (p.getText().equals("")) continue;
            this.add(new Paragraph(offset, p.getText(), dxfColor));
            offset += textHeight;
        }
    }

    private int getLayerColor() {
        return ((DXFMText)this.getEntity()).getDXFDocument().getDXFLayer(((DXFMText)this.getEntity()).getLayerName()).getColor();
    }

    private Iterator getParagraphIterator() {
        return ((DXFMText)this.getEntity()).getTextDocument().getStyledParagraphIterator();
    }

    @Override
    protected AffineTransform makeTransform() {
        Rectangle2D b = GeomUtils.getTextBounds(this.getFirstParagraph());
        double scaleY = ((DXFMText)this.getEntity()).getHeight() / b.getHeight();
        double scaleX = scaleY * ((DXFMText)this.getEntity()).getScaleX();
        AffineTransform at = AffineTransform.getTranslateInstance(((DXFMText)this.getEntity()).getInsertPoint().getX(), ((DXFMText)this.getEntity()).getInsertPoint().getY());
        at.rotate(Math.toRadians(((DXFMText)this.getEntity()).getRotation()));
        at.shear(Math.toRadians(((DXFMText)this.getEntity()).getObliqueAngle()), 0.0);
        at.scale(scaleX, -scaleY);
        at.translate(this.getAlign(b.getWidth()), -this.getVAlign(b.getHeight()));
        return at;
    }

    private String getFirstParagraph() {
        Iterator it = this.getParagraphIterator();
        while (it.hasNext()) {
            String text = ((StyledTextParagraph)it.next()).getText().trim();
            if (text.equals("")) continue;
            return text;
        }
        return "Lorem ipsum";
    }

    private double getAlign(double width) {
        switch (((DXFMText)this.getEntity()).getAlignment()) {
            default: {
                return 0.0;
            }
            case 2: 
            case 5: 
            case 8: {
                return -width / 2.0;
            }
            case 3: 
            case 6: 
            case 9: 
        }
        return -width;
    }

    private double getVAlign(double height) {
        switch (((DXFMText)this.getEntity()).getAlignment()) {
            case 1: 
            case 2: 
            case 3: {
                return -height;
            }
            case 4: 
            case 5: 
            case 6: {
                return -height / 2.0;
            }
        }
        return 0.0;
    }

    @Override
    public boolean contains(Point2D point) {
        return false;
    }

    @Override
    protected BasicStroke makeStroke() {
        return null;
    }

    @Override
    protected Path2D makeClip() {
        return null;
    }
}

