/*
 * Decompiled with CFR 0.152.
 */
package geom.entities.shapes;

import geom.AbstractShape;
import geom.entities.CompositeEntity;
import geom.exceptions.DxfTypeNotFoundException;
import java.awt.BasicStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kabeja.dxf.DXFBlock;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFInsert;
import org.kabeja.dxf.helpers.Point;

public final class Insert
extends CompositeEntity<DXFInsert> {
    public static final Log LOGGER = LogFactory.getLog(Insert.class);

    public Insert(DXFInsert entity) {
        super(entity);
        if (((DXFInsert)this.getEntity()).getColumns() > 1 || ((DXFInsert)this.getEntity()).getRows() > 1) {
            throw new Error("Not supported yet");
        }
    }

    private DXFBlock getDXFBlock() {
        return ((DXFInsert)this.getEntity()).getDXFDocument().getDXFBlock(((DXFInsert)this.getEntity()).getBlockID());
    }

    @Override
    protected void addShapes() {
        Iterator iterator = this.getDXFBlock().getDXFEntitiesIterator();
        while (iterator.hasNext()) {
            try {
                this.add(AbstractShape.getShape((DXFEntity)iterator.next()));
            }
            catch (DxfTypeNotFoundException ex) {
                LOGGER.debug((Object)("[" + ex.getType() + "] type not supported"));
            }
        }
    }

    @Override
    protected AffineTransform makeTransform() {
        Point p = this.getDXFBlock().getReferencePoint();
        AffineTransform at = AffineTransform.getTranslateInstance(((DXFInsert)this.getEntity()).getPoint().getX(), ((DXFInsert)this.getEntity()).getPoint().getY());
        at.rotate(Math.toRadians(((DXFInsert)this.getEntity()).getRotate()));
        at.scale(((DXFInsert)this.getEntity()).getScaleX(), ((DXFInsert)this.getEntity()).getScaleY());
        at.translate(-p.getX(), -p.getY());
        return at;
    }

    private double getEntityScale() {
        double scaleX = Math.abs(((DXFInsert)this.getEntity()).getScaleX());
        double scaleY = Math.abs(((DXFInsert)this.getEntity()).getScaleY());
        return scaleX + scaleY;
    }

    @Override
    protected BasicStroke makeStroke() {
        double scale = this.getEntityScale();
        double width = 0.0;
        if (scale > 0.0 || scale < 0.0) {
            width = 2.0 / scale;
        }
        return new BasicStroke((float)width);
    }

    @Override
    protected Path2D makeClip() {
        return null;
    }
}

