/*
 * Decompiled with CFR 0.152.
 */
package geom.entities.shapes;

import geom.AbstractShape;
import geom.entities.CompositeEntity;
import geom.entities.Entity;
import geom.exceptions.DxfTypeNotFoundException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFHatch;
import org.kabeja.dxf.DXFLine;
import org.kabeja.dxf.helpers.HatchBoundaryLoop;
import org.kabeja.dxf.helpers.HatchLineFamily;
import org.kabeja.dxf.helpers.HatchLineIterator;
import org.kabeja.dxf.helpers.HatchLineSegment;
import org.kabeja.dxf.helpers.Point;

public final class Hatch
extends CompositeEntity<DXFHatch> {
    public static final Log LOGGER = LogFactory.getLog(Hatch.class);
    public static final int MAX_LINES = 1000;
    public static final String SOLID_FILL = "SOLID";

    public Hatch(DXFEntity entity) {
        super((DXFHatch)entity);
    }

    private void iterateOnLines(HatchLineFamily family) {
        HatchLineIterator iterator = new HatchLineIterator((DXFHatch)this.getEntity(), family);
        int count = 0;
        while (iterator.hasNext()) {
            HatchLineSegment segment = (HatchLineSegment)iterator.next();
            if (segment.isSolid()) {
                this.addSingleLine(segment);
            } else {
                this.addMultipleLine(segment);
            }
            if (++count <= 1000) continue;
            LOGGER.warn((Object)"Hatch max lines overflow");
            break;
        }
    }

    private void addLine(Point start, Point end) {
        DXFLine line = new DXFLine();
        line.setStartPoint(start);
        line.setEndPoint(end);
        try {
            this.add(AbstractShape.getShape(line));
        }
        catch (DxfTypeNotFoundException ex) {
            LOGGER.debug((Object)("[" + ex.getType() + "] type not supported"));
        }
    }

    private void addSingleLine(HatchLineSegment segment) {
        this.addLine(segment.getStartPoint(), segment.getPointAt(segment.getLength()));
    }

    private void addMultipleLine(HatchLineSegment segment) {
        Point p1 = segment.getStartPoint();
        double length = 0.0;
        while (segment.hasNext()) {
            double l = segment.next();
            Point p2 = segment.getPointAt(length += Math.abs(l));
            if (l >= 0.0) {
                this.addLine(p1, p2);
            }
            p1 = p2;
        }
    }

    @Override
    protected void addShapes() {
        Iterator iterator = ((DXFHatch)this.getEntity()).getDXFDocument().getDXFHatchPattern(((DXFHatch)this.getEntity()).getDXFHatchPatternID()).getLineFamilyIterator();
        while (iterator.hasNext()) {
            this.iterateOnLines((HatchLineFamily)iterator.next());
        }
    }

    private int countVertex() {
        Iterator iterator = ((DXFHatch)this.getEntity()).getBoundaryLoops();
        int count = 0;
        while (iterator.hasNext()) {
            count += ((HatchBoundaryLoop)iterator.next()).getEdgeCount();
        }
        return count;
    }

    private static Line2D createLine(DXFLine line) {
        Point p1 = line.getStartPoint();
        Point p2 = line.getEndPoint();
        return new Line2D.Double(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    private void iterateOnBoundaries(HatchBoundaryLoop loop, Path2D path2D) throws DxfTypeNotFoundException {
        Iterator iterator = loop.getBoundaryEdgesIterator();
        boolean firstDraw = false;
        block10: while (iterator.hasNext()) {
            DXFEntity entity = (DXFEntity)iterator.next();
            switch (entity.getType()) {
                case "LINE": {
                    path2D.append(Hatch.createLine((DXFLine)entity), firstDraw);
                    if (firstDraw) continue block10;
                    firstDraw = true;
                    continue block10;
                }
                case "POLYLINE": {
                    try {
                        Entity shape = (Entity)AbstractShape.getShape(entity);
                        path2D.append((Path2D)shape.getShape(), false);
                    }
                    catch (DxfTypeNotFoundException ex) {
                        LOGGER.debug((Object)("[" + ex.getType() + "] type not supported"));
                    }
                    continue block10;
                }
            }
            throw new DxfTypeNotFoundException(entity.getType());
        }
    }

    @Override
    protected Path2D makeClip() {
        Path2D.Double path2D = new Path2D.Double(0, this.countVertex());
        Iterator iterator = ((DXFHatch)this.getEntity()).getBoundaryLoops();
        while (iterator.hasNext()) {
            try {
                this.iterateOnBoundaries((HatchBoundaryLoop)iterator.next(), path2D);
            }
            catch (DxfTypeNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        path2D.closePath();
        return path2D;
    }

    @Override
    public boolean contains(Point2D point) {
        return false;
    }

    @Override
    protected BasicStroke makeStroke() {
        return null;
    }

    @Override
    protected AffineTransform makeTransform() {
        return null;
    }

    @Override
    protected Color makeFillColor() {
        if (((DXFHatch)this.getEntity()).getName().equals(SOLID_FILL)) {
            return this.getColor();
        }
        return null;
    }
}

